package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;

public class AttributeMoveCommand extends Command
{

    private Attribute childAttribute;
    private int oldIndex, newIndex;
    private EntityBase parentEntity;
    
    public AttributeMoveCommand()
    {
        super();
        // TODO Auto-generated constructor stub
        System.out.println("AttributeMoveCommand()");
    }

    public AttributeMoveCommand(String label)
    {
        super(label);
        // TODO Auto-generated constructor stub
    }

    /**
     * @param childAttribute The childAttribute to set.
     */
    public void setChildAttribute(Attribute childAttribute)
    {
        this.childAttribute = childAttribute;
    }

    /**
     * @param newIndex The newIndex to set.
     */
    public void setNewIndex(int newIndex)
    {
        this.newIndex = newIndex;
    }

    /**
     * @param oldIndex The oldIndex to set.
     */
    public void setOldIndex(int oldIndex)
    {
        this.oldIndex = oldIndex;
    }

    /**
     * @param parentEntity The parentEntity to set.
     */
    public void setParentEntity(EntityBase parentEntity)
    {
        this.parentEntity = parentEntity;
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#execute()
     */
    @Override
    public void execute()
    {
        if (newIndex > oldIndex)
            newIndex--;
        parentEntity.switchAttribute(childAttribute, newIndex);
    }

    /* (non-Javadoc)
     * @see org.eclipse.gef.commands.Command#undo()
     */
    @Override
    public void undo()
    {
        parentEntity.switchAttribute(childAttribute, oldIndex);
      
    }
    

}
