/**
 * 
 */
package ter.diagram.editor.model.command;

import org.eclipse.gef.commands.Command;

import ter.diagram.editor.model.Attribute;

/**
 * @author nakaG
 *
 */
public class AttributeDirectEditCommand extends Command {
	private Attribute attribute;
	private String oldName;
	private String newName;
	
	public AttributeDirectEditCommand() {
		super();
	}

	/**
	 * @param attribute 設定する attribute
	 */
	public void setAttribute(Attribute attribute) {
		this.attribute = attribute;
	}

	/**
	 * @param oldName 設定する oldName
	 */
	public void setOldName(String oldName) {
		this.oldName = oldName;
	}

	/**
	 * @param newName 設定する newName
	 */
	public void setNewName(String newName) {
		this.newName = newName;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#execute()
	 */
	@Override
	public void execute() {
		attribute.setName(newName);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gef.commands.Command#undo()
	 */
	@Override
	public void undo() {
		attribute.setName(oldName);
	}
	
	
}
