package ter.diagram.editor.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.ComboBoxLabelProvider;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class EntityBase extends AbstractTMModel {
	private String name = "entity";
	private String type;
	private int entityType = ENTITY_TYPE_RESOURCE;
	public enum EntityType {R, E, TS, TO};
	private List<Identifier> identifieres = new ArrayList<Identifier>(0);
	private List<Identifier> reuseKeys = new ArrayList<Identifier>(0);
	private List<Attribute> attributes = new ArrayList<Attribute>(0);
	private List sourceRelationships = new ArrayList();
	private List targetRelationships = new ArrayList();
	private List children = new ArrayList(0);
	private Rectangle constraint;
	private Identifier identifier;
	public static final String P_CONSTRAINT = "_constraint";
    public static final String P_REORDER = "_reorder";
	public static final String P_SOURCE_RELATIONSHIP = "_source_relationship";
	public static final String P_TARGET_RELATIONSHIP = "_target_relationship";
	public static final String P_TYPE_ATTRIBUTE = "_type_attribute";
	public static final String P_TYPE_IDENTIFIER = "_type_identifier";
	public static final String P_ID_CHILDREN = "_id_children";
	public static final String LABEL_ENTITY_TYPE_RESOURCE = "R";
	public static final String LABEL_ENTITY_TYPE_EVENT = "E";
	public static final int ENTITY_TYPE_RESOURCE = 0;
	public static final int ENTITY_TYPE_EVENT = 1;
	public static final int ENTITY_TYPE_TS = 2;
	public static final int ENTITY_TYPE_TO = 3;

	public EntityBase() {
		super();
	}

	/**
	 * @return Returns the name.
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name The name to set.
	 */
	public void setName(String name) {
		this.name = name;
		firePropertyChange(P_NAME_ATTRIBUTE, null, name);
	}

	/**
	 * @return Returns the type.
	 */
	public String getType() {
		return type;
	}

	/**
	 * @param type The type to set.
	 */
	public void setType(String type) {
		this.type = type;
		firePropertyChange(P_TYPE_ATTRIBUTE, null, type);
	}

	/**
	 * @return Returns the identifieres.
	 */
	public List getIdentifieres() {
		return identifieres;
	}

	/**
	 * @param identifieres The identifieres to set.
	 */
	public void setIdentifieres(List identifieres) {
		this.identifieres = identifieres;
//		this.children.addAll(identifieres);
	}

	/**
	 * @return Returns the attributes.
	 */
	public List getAttributes() {
		return attributes;
	}

	/**
	 * @param attributes The attributes to set.
	 */
	public void setAttributes(List attributes) {
		this.attributes = attributes;
//		this.children.addAll(attributes);
		firePropertyChange(P_CHILDREN, null, attributes);
	}

	/**
	 * @return Returns the sourceRelationships.
	 */
	public List getSourceRelationships() {
		return sourceRelationships;
	}

	/**
	 * @param sourceRelationships The sourceRelationships to set.
	 */
	public void setSourceRelationships(List sourceRelationships) {
		this.sourceRelationships = sourceRelationships;
	}

	/**
	 * @return Returns the targetRelationships.
	 */
	public List getTargetRelationships() {
		return targetRelationships;
	}

	/**
	 * @param targetRelationships The targetRelationships to set.
	 */
	public void setTargetRelationships(List targetRelationships) {
		this.targetRelationships = targetRelationships;
	}

	/**
	 * @return Returns the constraint.
	 */
	public Rectangle getConstraint() {
		return constraint;
	}

	/**
	 * @param constraint The constraint to set.
	 */
	public void setConstraint(Rectangle constraint) {
		this.constraint = constraint;
		firePropertyChange(P_CONSTRAINT, null, constraint);
	}

	public void addSourceRelationship(Object relationship) {
		sourceRelationships.add(relationship);
		firePropertyChange(P_SOURCE_RELATIONSHIP, null, null);
	}
	
	public void addTargetRelationship(Object relationship) {
		targetRelationships.add(relationship);
		firePropertyChange(P_TARGET_RELATIONSHIP, null, null);
	}
	
	public void removeSourceRelationship(Object relationship) {
		sourceRelationships.remove(relationship);
		firePropertyChange(P_SOURCE_RELATIONSHIP, null, null);
	}
	
	public void removeTargetRelationship(Object relationship) {
		targetRelationships.remove(relationship);
		firePropertyChange(P_TARGET_RELATIONSHIP, null, null);
	}

	/* (non-Javadoc)
	 * @see ter.diagram.editor.model.AbstractTMModel#getPropertyDescriptors()
	 */
	public IPropertyDescriptor[] getPropertyDescriptors() {
		IPropertyDescriptor[] descriptors = 
			new IPropertyDescriptor[] {
				new TextPropertyDescriptor(P_NAME_ATTRIBUTE, "エンティティ名"),
				new ComboBoxPropertyDescriptor(P_TYPE_ATTRIBUTE, "エンティティタイプ", new String[] {LABEL_ENTITY_TYPE_RESOURCE, LABEL_ENTITY_TYPE_EVENT})};
		return descriptors;
	}

	/* (non-Javadoc)
	 * @see ter.diagram.editor.model.AbstractTMModel#getPropertyValue(java.lang.Object)
	 */
	public Object getPropertyValue(Object id) {
		if (id.equals(P_NAME_ATTRIBUTE)) {
			return name;
		} else if (id.equals(P_TYPE_ATTRIBUTE)) {
			return type;
		}
		return null;
	}

	/* (non-Javadoc)
	 * @see ter.diagram.editor.model.AbstractTMModel#isPropertySet(java.lang.Object)
	 */
	public boolean isPropertySet(Object id) {
		if (id.equals(P_NAME_ATTRIBUTE)) {
			return true;
		} else if (id.equals(P_TYPE_ATTRIBUTE)) {
			return false;
		} else {
			return false;
		}
	}

	/* (non-Javadoc)
	 * @see ter.diagram.editor.model.AbstractTMModel#setPropertyValue(java.lang.Object, java.lang.Object)
	 */
	public void setPropertyValue(Object id, Object value) {
		if (id.equals(P_NAME_ATTRIBUTE)) {
			setName((String) value);
		} else if (id.equals(P_TYPE_ATTRIBUTE)) {
			setType((String) value);
		}
	}
	
	public void addAttribute(Attribute attribute) {
		attributes.add(attribute);
        children.add(attribute);
		firePropertyChange(P_CHILDREN, null, attribute);
	}
    public void addAttribute(Attribute attribute, int index) {
        attributes.add(index, attribute);
        children.add(attribute);
        firePropertyChange(P_CHILDREN, null, attribute);
    }	public void removeAttribute(Attribute attribute) {
		attributes.remove(attribute);
        children.remove(attribute);
		firePropertyChange(P_CHILDREN, attribute, null);
	}
	
	public void addIdentifier(Identifier identifier) {
		identifieres.add(identifier);
        children.add(identifier);
		firePropertyChange(P_ID_CHILDREN, null, identifier);
	}
	public void setIdentifier(int idx, Identifier identifier) {
		identifieres.set(idx, identifier);
        children.set(idx, identifier);
		firePropertyChange(P_ID_CHILDREN, null, identifier);
	}

	public void removeIdentifier(Identifier identifier) {
		identifieres.remove(identifier);
		children.remove(identifier);
		firePropertyChange(P_ID_CHILDREN, identifier, null);
	}

    /**
     * @return Returns the children.
     */
    public List getChildren()
    {
        return children;
    }
    public void switchAttribute(Attribute attribute, int index) {
        attributes.remove(attribute);
        attributes.add(index, attribute);
        firePropertyChange(P_REORDER, this, attribute);
    }

	/**
	 * @return entityType
	 */
	public int getEntityType() {
		return entityType;
	}

	/**
	 * @param entityType 設定する entityType
	 */
	public void setEntityType(int entityType) {
		this.entityType = entityType;
		firePropertyChange(P_TYPE_ATTRIBUTE, null, entityType);
	}

	/**
	 * @return identifier
	 */
	public Identifier getIdentifier() {
		return identifier;
	}

	/**
	 * @param identifier 設定する identifier
	 */
	public void setIdentifier(Identifier identifier) {
		Identifier old = this.identifier;
//		this.reuseKeys.remove(old);
		this.identifier = identifier;
//		this.reuseKeys.add(identifier);
		firePropertyChange(P_TYPE_IDENTIFIER, old, identifier);
	}

	/**
	 * @return the reuseKeys
	 */
	public List<Identifier> getReuseKeys() {
		return reuseKeys;
	}

	/**
	 * @param reuseKeys the reuseKeys to set
	 */
	public void setReuseKeys(List<Identifier> reuseKeys) {
		this.reuseKeys = reuseKeys;
	}
    
//    public void addChild(Object obj) {
//        children.add(obj);
//        firePropertyChange(P_CHILDREN, null, obj);
//    }
//    public void removeChild(Object obj) {
//        children.remove(obj);
//        firePropertyChange(P_CHILDREN, obj, null);
//    }
}
