package ter.diagram.editor.figure;

import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;

public class TFormLayout extends AbstractHintLayout {
	/**
	 * Constant to be used as a constraint for child figures
	 */
	public static final Integer TOP = new Integer(PositionConstants.TOP);

	/**
	 * Constant to be used as a constraint for child figures
	 */
	public static final Integer DEBIT = new Integer(PositionConstants.ALWAYS_LEFT);

	/**
	 * Constant to be used as a constraint for child figures
	 */
	public static final Integer CREDIT = new Integer(PositionConstants.ALWAYS_RIGHT);

	private IFigure debit, credit, top;
	private int vGap = 0, hGap = 0;

	public TFormLayout() {
		super();
		// TODO Auto-generated constructor stub
	}

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.AbstractLayout#calculatePreferredSize(org.eclipse.draw2d.IFigure, int, int)
	 */
	protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        System.out.println("TFormLayout#calculatePreferredSize()");

		int minWHint = 0, minHHint = 0;
		if (wHint < 0)
			minWHint = -1;
		
		if (hHint < 0)
			minHHint = -1;
		
		Insets border = container.getInsets();
		wHint = Math.max(minWHint, wHint - border.getWidth());
		hHint = Math.max(minHHint, hHint - border.getHeight());
		Dimension prefSize = new Dimension();
		int middleRowWidth = 0, middleRowHeight = 0;
		int rows = 0, columns = 0;

		if (top != null && top.isVisible()) {
			Dimension childSize = top.getPreferredSize(wHint, hHint);
			hHint = Math.max(minHHint, hHint - (childSize.height + vGap));
			prefSize.setSize(childSize);
			rows += 1;
		}
		if (debit != null && debit.isVisible()) {
			Dimension childSize = debit.getPreferredSize(wHint, hHint);
			middleRowWidth = childSize.width;
			middleRowHeight = childSize.height;
			wHint = Math.max(minWHint, wHint - (childSize.width + hGap));
			columns += 1;
		}
		if (credit != null && credit.isVisible()) {
			Dimension childSize = credit.getPreferredSize(wHint, hHint);
			middleRowWidth += childSize.width;
			middleRowHeight = Math.max(childSize.height, middleRowHeight);
			wHint = Math.max(minWHint, wHint - (childSize.width + hGap));
			columns += 1;
		}

		rows += columns > 0 ? 1 : 0;
		// Add spacing, insets, and the size of the middle row
		prefSize.height += middleRowHeight + border.getHeight() + ((rows - 1) * vGap);
		prefSize.width = Math.max(prefSize.width, middleRowWidth) + border.getWidth() 
						+ ((columns - 1) * hGap);
		
		return prefSize;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.LayoutManager#layout(org.eclipse.draw2d.IFigure)
	 */
	public void layout(IFigure container) {
        System.out.println("TFormLayout#layout()");
        if (container == null) {
            System.out.println("container == null");
            return;
        }
		Rectangle area = container.getClientArea();
		Rectangle rect = new Rectangle();
        if (area == null) {
            System.out.println("area == null");
            return;
        }

		Dimension childSize;

		if (top != null && top.isVisible()) {
			childSize = top.getPreferredSize(area.width, -1);
            if (childSize == null) {
                System.out.println("childSize == null");
                return;
            }
			rect.setLocation(area.x, area.y);
			rect.setSize(childSize);
			rect.width = area.width;
			top.setBounds(rect);
			area.y += rect.height + vGap;
			area.height -= rect.height + vGap;
		}
		if (debit != null && debit.isVisible()) {
			childSize = debit.getPreferredSize(Math.max(0, area.width / 2), Math.max(0, area.height));
            if (childSize == null) {
                System.out.println("childSize == null");
                return;
            }
			rect.setLocation(area.x, area.y);
			rect.width = Math.max(0, area.width / 2);
			rect.height = Math.max(0, area.height);
			debit.setBounds(rect);
			area.x += rect.width + hGap;
			area.width -= rect.width + hGap;
		}
		if (credit != null && credit.isVisible()) {
			childSize = credit.getPreferredSize(Math.max(0, area.width), Math.max(0, area.height));
            if (childSize == null) {
                System.out.println("childSize == null");
                return;
            }
			rect.width = Math.max(0, area.width);
			rect.height = Math.max(0, area.height);
			rect.setLocation(area.x + area.width - rect.width, area.y);
			credit.setBounds(rect);
			area.width -= rect.width + hGap;
        }
        System.out.println("TFormLayout#layout() end.");
    }

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.AbstractLayout#setConstraint(org.eclipse.draw2d.IFigure, java.lang.Object)
	 */
	public void setConstraint(IFigure child, Object constraint) {
        System.out.println("TFormLayout#setConstraint()");

		remove(child);
		super.setConstraint(child, constraint);
		if (constraint == null) {
			return;
		}
		switch (((Integer) constraint).intValue()) {
		case PositionConstants.TOP :
			top = child;
			break;
		case PositionConstants.ALWAYS_LEFT :
			debit = child;
			break;
		case PositionConstants.ALWAYS_RIGHT :
			credit = child;
			break;
		default :
			break;
		}
	}
}
