package ter.diagram.editor.figure;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;

public class EntityBaseFigure extends Figure {
	private CompartmentFigure identifierContainerFigure = new CompartmentFigure();
	private CompartmentFigure attributeContainerFigure = new CompartmentFigure();
	private EntityBaseTitleFigure entityTitleFigure = new EntityBaseTitleFigure();
	private TitleLabel entityName;
	private EntityTypeLabel entityType;
	private IdentifierLabel identifier;
	
	public EntityBaseFigure() {
		this("");
	}
	public EntityBaseFigure(String name) {
		this(name, "R");
	}

	public EntityBaseFigure(String name, String entityType) {
		setBorder(new LineBorder(1));
		setBackgroundColor(ColorConstants.orange);
		setOpaque(true);

		this.entityName = new TitleLabel(name);
		this.entityType = new EntityTypeLabel(entityType);
		
		entityTitleFigure.add(this.entityName);
		entityTitleFigure.add(this.entityType);
		add(entityTitleFigure);
		add(identifierContainerFigure);
		add(attributeContainerFigure);

		TFormLayout layout = new TFormLayout();
		layout.setConstraint(entityTitleFigure, TFormLayout.TOP);
		layout.setConstraint(identifierContainerFigure, TFormLayout.DEBIT);
		layout.setConstraint(attributeContainerFigure, TFormLayout.CREDIT);
		setLayoutManager(layout);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.Figure#add(org.eclipse.draw2d.IFigure, java.lang.Object, int)
	 */
	public void add(IFigure figure, Object constraint, int index) {
        super.add(figure, constraint, index);
		System.out.println("EntityBaseFigure#add().");
		if (figure instanceof AttributeLabel) {
			System.out.println("EntityBaseFigure#add(). AttributeLabel");
			attributeContainerFigure.add(figure);
//            attributeContainerFigure.repaint();
		} else if (figure instanceof IdentifierLabel) {
			System.out.println("EntityBaseFigure#add(). IdentifierLabel");
//			if (identifier == null) {
//				identifier = (IdentifierLabel)figure;
//			}
			identifierContainerFigure.add(figure);
		} else if (figure instanceof TitleLabel) {
			System.out.println("EntityBaseFigure#add(). TitleLabel");
			entityTitleFigure.add(figure);
		} else if (figure instanceof EntityTypeLabel) {
			System.out.println("EntityBaseFigure#add(). EntityTypeLabel");
			entityTitleFigure.add(figure);
		} else {
			System.out.println("EntityBaseFigure#add(). " + figure);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.draw2d.Figure#remove(org.eclipse.draw2d.IFigure)
	 */
//	public void remove(IFigure figure) {
//		if (figure instanceof AttributeLabel) {
//			attributeContainerFigure.remove(figure);
////			getLayoutManager().setConstraint(attributeContainerFigure, TFormLayout.CREDIT);
//		} else if (figure instanceof IdentifierLabel) {
//			identifierContainerFigure.remove(figure);
//		} else if (figure instanceof TitleLabel) {
//			entityTitleFigure.remove(figure);
//		} else if (figure instanceof EntityTypeLabel) {
//			entityTitleFigure.remove(figure);
//		} else {
//			super.remove(figure);
////			System.out.println("Unknown figure removed." + figure.getClass().getName());
//		}
//	}

	/**
	 * @param entityName The entityName to set.
	 */
	public void setEntityName(String entityName) {
		this.entityName.setText(entityName);
	}

	/**
	 * @return entityName
	 */
	public TitleLabel getEntityName() {
		return entityName;
	}

	/**
	 * @param entityType The entityType to set.
	 */
	public void setEntityType(String entityType) {
		this.entityType.setText(entityType);
	}
	
	/**
	 * @return entityType
	 */
	public EntityTypeLabel getEntityType() {
		return entityType;
	}

	public CompartmentFigure getAttributeContainerFigure() {
		return attributeContainerFigure;
	}
	
	/**
	 * @return identifierContainerFigure
	 */
	public CompartmentFigure getIdentifierContainerFigure() {
		return identifierContainerFigure;
	}
	public IdentifierLabel getIdentifier() {
		return this.identifier;
	}
	public void setIdentifier(IdentifierLabel identifier) {
		identifierContainerFigure.remove(this.identifier);
		this.identifier = identifier;
		identifierContainerFigure.add(identifier, 0);
		
	}
	public void removeAllAttributes() {
		attributeContainerFigure.removeAll();
	}
	public void removeAllIdentifieres() {
		identifierContainerFigure.removeAll();
	}
}
