package ter.diagram.editor.editpolicy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;

import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.TMDiagram;
import ter.diagram.editor.model.command.CreateRelationshipCommand;
import ter.diagram.editor.model.command.EntityBaseCreateCommand;
import ter.diagram.editor.model.command.RelationshipCreateCommand;
import ter.diagram.editor.model.command.RelationshipReconnectCommand;

public class TMDiagramGraphicalNodeEditPolicy extends GraphicalNodeEditPolicy {

	public TMDiagramGraphicalNodeEditPolicy() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected Command getConnectionCompleteCommand(
			CreateConnectionRequest request) {
//		CreateRelationshipCommand command =
//			(CreateRelationshipCommand) request.getStartCommand();
//		command.setTarget(getHost().getModel());
		RelationshipCreateCommand command = 
			(RelationshipCreateCommand) request.getStartCommand();
		command.setTarget((EntityBase) getHost().getModel());
		
		List<Integer> list = new ArrayList<Integer>();
		list.add(command.getSource().getEntityType());
		list.add(command.getTarget().getEntityType());
		Collections.sort(list);
		int ftype = list.get(0);
		int stype = list.get(1);
	
		Command retCmd = null;
		if (ftype == EntityBase.ENTITY_TYPE_RESOURCE &&
			stype == EntityBase.ENTITY_TYPE_RESOURCE) {
			System.out.println("Crete CombinationTable");

			CompoundCommand ccomand = new CompoundCommand();
			Point src = command.getSource().getConstraint().getCenter();
			Point tgt = command.getTarget().getConstraint().getCenter();
		
			int x = Math.max(src.x, tgt.x) - (Math.max(src.x, tgt.x) - Math.min(src.x, tgt.x))/2;
			int y = Math.max(src.y, tgt.y) - (Math.max(src.y, tgt.y) - Math.min(src.y, tgt.y))/2;
			Point p = new Point(x, y);
			System.out.println("center =" + p);
			Rectangle rect = new Rectangle(p.x, p.y, 15, 15);
			
			EntityBase base = new EntityBase();
			base.setConstraint(rect);
//			base.setConstraint(new Rectangle());
			System.out.println("Crete new Entity");
			
			TMDiagram diagram = (TMDiagram) getHost().getParent().getModel();
			EntityBaseCreateCommand cmd = new EntityBaseCreateCommand();
			cmd.setEntity(base);
			System.out.println("Crete CombinationTableCommand setEntity");
			cmd.setDiagram(diagram);
			System.out.println("Crete CombinationTableCommand setDiagram");
//			command.add(cmd);
			ccomand.add(cmd);
			ccomand.add(getCreateRelationshipCommand(command.getSource(), base));
			ccomand.add(getCreateRelationshipCommand(command.getTarget(), base));
			EntityBase combinationTable = new EntityBase();

//			combinationTable.addIdentifier(command.getSource().getIdentifier());
//			combinationTable.addIdentifier(command.getTarget().getIdentifier());
			
			Rectangle newRect = new Rectangle(rect.x - 15, rect.y + 50, -1, -1);
			combinationTable.setConstraint(newRect);
			EntityBaseCreateCommand ctCmd = new EntityBaseCreateCommand();
			ctCmd.setDiagram(diagram);
			ctCmd.setEntity(combinationTable);

			ccomand.add(ctCmd);
			
			ccomand.add(getCreateRelationshipCommand(base, combinationTable));
			retCmd = ccomand;
		} else if (ftype == EntityBase.ENTITY_TYPE_RESOURCE &&
				   stype == EntityBase.ENTITY_TYPE_EVENT) {
			System.out.println("Replicate Identifier");
//			command.add(getCreateRelationshipCommand(command));
			retCmd = getCreateRelationshipCommand(command.getSource(), command.getTarget());
		} else if (ftype == EntityBase.ENTITY_TYPE_EVENT &&
				   stype == EntityBase.ENTITY_TYPE_EVENT) {
			System.out.println("Create MappingTable");
//			command.add(getCreateRelationshipCommand(command));
			retCmd = getCreateRelationshipCommand(command.getSource(), command.getTarget());
		}
		EntityBase s = command.getSource();
		EntityBase t = command.getTarget();

		Command execCmd = null;
		if (s.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE) {
			// 対照表
			if (t.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE) {
//				idを(R)に設定
			}
			// idをコピー
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) {
//				idを(R)に設定
				execCmd = getCreateRelationshipCommand(s, t);
				
			}
			// 対照表
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_TS) {
				
			}
		}
		else if (s.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) {
			// idをコピー
			if (t.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE) {
				
			}
			// idをコピー or 対応表
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) {
				
			}
			// idをコピー
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_TS) {
				
			}
		}
		else if (s.getEntityType() == EntityBase.ENTITY_TYPE_TS) {
			// 対象表
			if (t.getEntityType() == EntityBase.ENTITY_TYPE_RESOURCE) {
				
			}
			// idをコピー
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_EVENT) {
				
			}
			// 対象表
			else if (t.getEntityType() == EntityBase.ENTITY_TYPE_TS) {
				
			}
			
		}
		// TODO Recursive, E and E (1:N or N:1)
		return retCmd;
	}
	private Command getCreateRelationshipCommand(EntityBase source, EntityBase target) {
		CreateRelationshipCommand cmd = new CreateRelationshipCommand();
		cmd.setRelationship(new RelationshipConnection());
		cmd.setSource(source);
		cmd.setTarget(target);
		return cmd;
	}
	private Command getCreateRelationshipCommand(EntityBase source, EntityBase target, List reuseSourceIds, List reuseTargetIds) {
		CreateRelationshipCommand cmd = new CreateRelationshipCommand();
		cmd.setRelationship(new RelationshipConnection());
		cmd.setSource(source);
		cmd.setTarget(target);
		cmd.setReuseSourceIds(reuseSourceIds);
		cmd.setReuseTargetIds(reuseTargetIds);
		return cmd;
	}
	
	protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
//		CreateRelationshipCommand command = new CreateRelationshipCommand();
//		command.setRelationship(request.getNewObject());
//		command.setSource(getHost().getModel());
//		request.setStartCommand(command);
		
		RelationshipCreateCommand command = new RelationshipCreateCommand();
		command.setSource((EntityBase) getHost().getModel());
		request.setStartCommand(command);

		return command;
	}

	protected Command getReconnectTargetCommand(ReconnectRequest request) {
		RelationshipReconnectCommand command = new RelationshipReconnectCommand();
		command.setRelationship((RelationshipConnection) request.getConnectionEditPart().getModel());
		command.setNewTarget((EntityBase) getHost().getModel());
		return command;
	}

	protected Command getReconnectSourceCommand(ReconnectRequest request) {
		RelationshipReconnectCommand command = new RelationshipReconnectCommand();
		command.setRelationship((RelationshipConnection) request.getConnectionEditPart().getModel());
		command.setNewSource((EntityBase) getHost().getModel());
		return command;
	}

}
