package ter.diagram.editor.editpolicy;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.OrderedLayoutEditPolicy;
import org.eclipse.gef.requests.CreateRequest;

import ter.diagram.editor.editpart.AttributeEditPart;
import ter.diagram.editor.editpart.EntityBaseEditPart;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.command.AttributeMoveCommand;
import ter.diagram.editor.model.command.AttributeTransferCommand;

public class EntityLayoutEditPolicy2 extends OrderedLayoutEditPolicy {

	@Override
	protected Command createAddCommand(EditPart child, EditPart after) {
		System.out.println("EntityLayoutEditPolicy2.createAddCommand");
		if (!(child instanceof AttributeEditPart))
            return null;
        if (!(after instanceof AttributeEditPart))
            return null;
        
        Attribute toMove = (Attribute) child.getModel();
        Attribute afterModel = (Attribute) after.getModel();
        
        EntityBaseEditPart originalEntityEditPart = (EntityBaseEditPart)child.getParent();
        EntityBase originalEntity = (EntityBase)originalEntityEditPart.getModel();
        EntityBaseEditPart newEntityEditPart = (EntityBaseEditPart)after.getParent();
        EntityBase newEntity = (EntityBase)newEntityEditPart.getModel();
        
        int oldIndex = originalEntityEditPart.getChildren().indexOf(child);
        int newIndex = newEntityEditPart.getChildren().indexOf(after);
        
        AttributeTransferCommand command = new AttributeTransferCommand();
        command.setAttributeToMove(toMove);
        command.setAttributeAfter(afterModel);
        command.setOriginalEntity(originalEntity);
        command.setNewEntity(newEntity);
        command.setOldIndex(oldIndex);
        command.setNewIndex(newIndex);
        
		return command;
	}

	@Override
	protected Command createMoveChildCommand(EditPart child, EditPart after) {
		System.out.println("EntityLayoutEditPolicy2.createMoveChildCommand");
        
        if (after != null) {
            Attribute childModel = (Attribute) child.getModel();
            
            EntityBase parentEntity = (EntityBase) getHost().getModel();
            int oldIndex = getHost().getChildren().indexOf(child);
            int newIndex = getHost().getChildren().indexOf(after);
            
            AttributeMoveCommand command = new AttributeMoveCommand();
            command.setChildAttribute(childModel);
            command.setOldIndex(oldIndex);
            command.setNewIndex(newIndex);
            command.setParentEntity(parentEntity);
            return command;
        }
		return null;

	}

	@Override
	protected EditPart getInsertionReference(Request arg0) {
		// TODO 自動生成されたメソッド・スタブ
		System.out.println("EntityLayoutEditPolicy2.getInsertionReference");
		return null;
	}

	@Override
	protected Command getCreateCommand(CreateRequest arg0) {
		// TODO 自動生成されたメソッド・スタブ
		System.out.println("EntityLayoutEditPolicy2.getCreateCommand");
		return null;
	}

}
