package ter.diagram.editor.editpolicy;

import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.ContainerEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.GroupRequest;

import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.command.AttributeCreateCommand;
import ter.diagram.editor.model.command.CreateIdentifierCommand;

public class EntityContainerEditPolicy extends ContainerEditPolicy {

	public EntityContainerEditPolicy() {
		super();
		// TODO Auto-generated constructor stub
	}

	protected Command getCreateCommand(CreateRequest request) {
        System.out.println("EntityContainerEditPolicy.getCreateCommand");

		Object newObject = request.getNewObject();
		
		if (!(newObject instanceof Attribute)) {
			return null;
		}
		EntityBase entity = (EntityBase) getHost().getModel();
		if (newObject instanceof Identifier) {
			CreateIdentifierCommand command = new CreateIdentifierCommand();
			command.setEntity(entity);
			Identifier identifier = (Identifier) newObject;
			identifier.setName(entity.getName() + "No");
			command.setIdentifier(identifier);
			return command;
		} else {
			AttributeCreateCommand command = new AttributeCreateCommand();
			command.setEntity(entity);
			Attribute attr = (Attribute) newObject;
			attr.setName("attribute"+ (entity.getAttributes().size() + 1));
			command.setAttribute(attr);
			return command;
		}
	}
}
