package ter.diagram.editor.editpart;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;

import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.RelationshipConnection;
import ter.diagram.editor.model.TMDiagram;

public class TMEditPartFactory implements EditPartFactory {

	public TMEditPartFactory() {
		super();
	}

	public EditPart createEditPart(EditPart context, Object model) {
		EditPart part = null;
		
		if (model instanceof TMDiagram) {
			part = new TMDiagramEditPart();
		} else if (model instanceof EntityBase) {
			part = new EntityBaseEditPart();
		} else if (model instanceof Identifier) {
			part = new IdentifierEditPart();
		} else if (model instanceof Attribute) {
			part = new AttributeEditPart();
		} else if (model instanceof RelationshipConnection) {
			part = new RelationshipEditPart();
		}
		part.setModel(model);
		return part;
	}

}
