package ter.diagram.editor.editpart;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.TextCellEditor;

import ter.diagram.editor.EntityBaseDirectEditUtil;
import ter.diagram.editor.directedit.EntityBaseIdentifierCellEditorLocator;
import ter.diagram.editor.directedit.EntityBaseIdentifierDirectEditManager;
import ter.diagram.editor.directedit.EntityBaseNameCellEditorLocator;
import ter.diagram.editor.directedit.EntityBaseNameDirectEditManager;
import ter.diagram.editor.directedit.EntityBaseTypeCellEditorLocator;
import ter.diagram.editor.directedit.EntityBaseTypeDirectEditManager;
import ter.diagram.editor.directedit.EntityTypeCellEditor;
import ter.diagram.editor.editpolicy.EntityBaseComponentEditPolicy;
import ter.diagram.editor.editpolicy.EntityBaseDirectEditPolicy;
import ter.diagram.editor.editpolicy.EntityContainerEditPolicy;
import ter.diagram.editor.editpolicy.EntityLayoutEditPolicy;
import ter.diagram.editor.editpolicy.EntityLayoutEditPolicy2;
import ter.diagram.editor.editpolicy.TMDiagramGraphicalNodeEditPolicy;
import ter.diagram.editor.figure.EntityBaseFigure;
import ter.diagram.editor.figure.EntityTypeLabel;
import ter.diagram.editor.figure.IdentifierLabel;
import ter.diagram.editor.figure.TitleLabel;
import ter.diagram.editor.model.AbstractTMModel;
import ter.diagram.editor.model.Attribute;
import ter.diagram.editor.model.EntityBase;
import ter.diagram.editor.model.Identifier;
import ter.diagram.editor.model.TMDiagram;

public class EntityBaseEditPart extends EditPartWithListener implements NodeEditPart
{
	protected DirectEditManager nameDirectManager;
	protected DirectEditManager typeDirectManaget;
	protected DirectEditManager identifierDirectManager;
	
    public EntityBaseEditPart()
    {
        super();
        System.out.println("EntityBaseEditPart instanciate.");
        // TODO Auto-generated constructor stub
    }

    protected IFigure createFigure()
    {
    	System.out.println("EntityBaseEditPart createFigure()");
//        EntityBase model = (EntityBase) getModel();
        EntityBaseFigure figure = new EntityBaseFigure();
        updateFigure(figure);
//        if (model.getIdentifier() != null)
//        {
//            Identifier idModel = model.getIdentifier();
//            IdentifierLabel identifier = new IdentifierLabel(idModel.getName());
//            figure.add(identifier);
//            // EditPart editPart = createChild(idModel);
//            // int modelIndex = getModelChildren().indexOf(idModel);
//            // addChild(editPart, modelIndex);
//        }
        return figure;
    }

    protected void createEditPolicies()
    {
        installEditPolicy(EditPolicy.GRAPHICAL_NODE_ROLE, new TMDiagramGraphicalNodeEditPolicy());
//        installEditPolicy(EditPolicy.LAYOUT_ROLE, new EntityLayoutEditPolicy2());
        installEditPolicy(EditPolicy.LAYOUT_ROLE, new EntityLayoutEditPolicy());
        installEditPolicy(EditPolicy.CONTAINER_ROLE, new EntityContainerEditPolicy());
        installEditPolicy(EditPolicy.COMPONENT_ROLE, new EntityBaseComponentEditPolicy());
        installEditPolicy(EditPolicy.DIRECT_EDIT_ROLE, new EntityBaseDirectEditPolicy());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editparts.AbstractEditPart#refreshVisuals()
     */
    protected void refreshVisuals()
    {
        Rectangle constraint = ((EntityBase) getModel()).getConstraint();
        ((GraphicalEditPart) getParent()).setLayoutConstraint(this, getFigure(), constraint);
//        EntityBaseFigure entityFigure = (EntityBaseFigure)getFigure();
//        Point location = entityFigure.getLocation();
//        TMDiagramEditPart parent = (TMDiagramEditPart)getParent();
//        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
//        parent.setLayoutConstraint(this, entityFigure, constraint);
//        updateFigure(getEntityBaseFigure());
        refreshChildren();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editparts.AbstractEditPart#getModelChildren()
     */
    protected List getModelChildren()
    {
        // List children = new ArrayList();
        EntityBase entity = (EntityBase) getModel();
        // children.addAll(entity.getIdentifieres());
        // children.addAll(entity.getAttributes());
        // return children;
        List children = new ArrayList();
        children.addAll(entity.getIdentifieres());
        children.addAll(entity.getAttributes());
        // return children;
        return entity.getAttributes();
        // return entity.getChildren();
    }

    private void updateFigure(EntityBaseFigure figure) {
    	System.out.println("EntityBaseEditPart updateFigure()");

    	EntityBase model = (EntityBase)getModel();
    	figure.setEntityName(model.getName());
    	int value = model.getEntityType();
        if (value == EntityBase.ENTITY_TYPE_RESOURCE) {
        	figure.setEntityType(EntityBase.LABEL_ENTITY_TYPE_RESOURCE);
        } else if (value == EntityBase.ENTITY_TYPE_EVENT) {
        	figure.setEntityType(EntityBase.LABEL_ENTITY_TYPE_EVENT);
        }
        System.out.println(model.getReuseKeys().size());
//        figure.removeAllAttributes();
        figure.removeAllIdentifieres();
        Identifier identifier = model.getIdentifier();
        if (identifier != null) {
        	figure.add(new IdentifierLabel(identifier.getName()));
        }
        for(Iterator identifieres = model.getReuseKeys().iterator();identifieres.hasNext(); ) {
        	Identifier id = (Identifier)identifieres.next();
        	IdentifierLabel idFigure = new IdentifierLabel(id.getName() + "(R)");
        	figure.add(idFigure);
        }
    }
    /*
     * (non-Javadoc)
     * 
     * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
     */
    public void propertyChange(PropertyChangeEvent evt)
    {
        if (evt.getPropertyName().equals(EntityBase.P_CONSTRAINT))
        {
            refreshVisuals();
        }
        else if (evt.getPropertyName().equals(EntityBase.P_SOURCE_RELATIONSHIP))
        {
            refreshSourceConnections();
//            updateFigure(getEntityBaseFigure());
        }
        else if (evt.getPropertyName().equals(EntityBase.P_TARGET_RELATIONSHIP))
        {
            refreshTargetConnections();
//        	getParent().refresh();
//            updateFigure(getEntityBaseFigure());
        }
        else if (evt.getPropertyName().equals(EntityBase.P_NAME_ATTRIBUTE))
        {
        	refreshVisuals();
            updateFigure(getEntityBaseFigure());

//            EntityBaseFigure entity = getEntityBaseFigure();
//            entity.setEntityName((String) evt.getNewValue());
        }
        else if (evt.getPropertyName().equals(EntityBase.P_TYPE_ATTRIBUTE))
        {
        	refreshVisuals();
            updateFigure(getEntityBaseFigure());
//            EntityBaseFigure entity = getEntityBaseFigure();
//        	updateFigure(entity);
//            int value = (Integer) evt.getNewValue();
//            if (value == EntityBase.ENTITY_TYPE_RESOURCE) {
//            	entity.setEntityType(EntityBase.LABEL_ENTITY_TYPE_RESOURCE);
//            } else if (value == EntityBase.ENTITY_TYPE_EVENT) {
//            	entity.setEntityType(EntityBase.LABEL_ENTITY_TYPE_EVENT);
//            }
//
        }
        else if (evt.getPropertyName().equals(AbstractTMModel.P_CHILDREN))
        {
            Object oldValue = evt.getOldValue();
            Object newValue = evt.getNewValue();
            if (newValue != null)
            {
                EditPart editPart = createChild(newValue);
                int modelIndex = getModelChildren().indexOf(newValue);
                addChild(editPart, modelIndex);
                // addChild(editPart, -1);
            }
            else
            {
                List children = getChildren();
                EditPart partToRemove = null;
                for (Iterator iter = children.iterator(); iter.hasNext();)
                {
                    EditPart part = (EditPart) iter.next();
                    if (part.getModel() == oldValue)
                    {
                        partToRemove = part;
                        break;
                    }
                }
                if (partToRemove != null)
                    removeChild(partToRemove);
            }

            // refreshChildren();
        }
        else if (evt.getPropertyName().equals(EntityBase.P_REORDER))
        {
            refreshChildren();
            refreshVisuals();
        }
//        else if (evt.getPropertyName().equals(EntityBase.P_NAME_ATTRIBUTE))
//        {
//            refreshVisuals();
//        	EntityBaseFigure entity = getEntityBaseFigure();
//        	updateFigure(entity);
//        	refreshVisuals();
//        	entity.setEntityName((String)evt.getNewValue());
//        }
        else if (evt.getPropertyName().equals(EntityBase.P_TYPE_IDENTIFIER))
        {
        	System.out.println("EntityBaseEditPart.P_TYPE_IDENTIFIER");
//        	EntityBaseFigure entity = getEntityBaseFigure();
//        	Identifier identifier = (Identifier)evt.getNewValue();
//        	IdentifierLabel idLabel = new IdentifierLabel(identifier.getName());
//        	entity.setIdentifier(idLabel);
        	refreshVisuals();
            updateFigure(getEntityBaseFigure());
        }
        else if (evt.getPropertyName().equals(EntityBase.P_ID_CHILDREN))
        {
        	System.out.println("EntityBaseEditPart.P_ID_CHILDREN");
//        	EntityBaseFigure entity = getEntityBaseFigure();
//        	updateFigure(entity);
        	refreshVisuals();
            updateFigure(getEntityBaseFigure());
        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.NodeEditPart#getSourceConnectionAnchor(org.eclipse.gef.ConnectionEditPart)
     */
    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection)
    {
        return new ChopboxAnchor(getFigure());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.NodeEditPart#getSourceConnectionAnchor(org.eclipse.gef.Request)
     */
    public ConnectionAnchor getSourceConnectionAnchor(Request request)
    {
        return new ChopboxAnchor(getFigure());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.NodeEditPart#getTargetConnectionAnchor(org.eclipse.gef.ConnectionEditPart)
     */
    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection)
    {
        return new ChopboxAnchor(getFigure());
   }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.NodeEditPart#getTargetConnectionAnchor(org.eclipse.gef.Request)
     */
    public ConnectionAnchor getTargetConnectionAnchor(Request request)
    {
        return new ChopboxAnchor(getFigure());
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#getModelSourceConnections()
     */
    protected List getModelSourceConnections()
    {
        return ((EntityBase) getModel()).getSourceRelationships();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#getModelTargetConnections()
     */
    protected List getModelTargetConnections()
    {
        return ((EntityBase) getModel()).getTargetRelationships();
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.gef.editparts.AbstractGraphicalEditPart#getContentPane()
     */
@Override
    public IFigure getContentPane()
    {
        EntityBaseFigure figure = getEntityBaseFigure();
        return figure.getAttributeContainerFigure();
    }

	/* (non-Javadoc)
	 * @see org.eclipse.gef.editparts.AbstractEditPart#performRequest(org.eclipse.gef.Request)
	 */
	@Override
	public void performRequest(Request req) {
		if (req.getType() == RequestConstants.REQ_DIRECT_EDIT) {
			System.out.println("EntityBaseEditPart.performRequest() REQ_DIRECT_EDIT");

			if (req instanceof DirectEditRequest) {
				System.out.println("DirectEditRequest");
				Point location = ((DirectEditRequest)req).getLocation().getCopy();
				
				if (EntityBaseDirectEditUtil.directEditTypeHitTest(location, getEntityBaseFigure())) {
					performTypeDirectEdit();
				} else if (EntityBaseDirectEditUtil.directEditNameHitTest(location, getEntityBaseFigure())) {
					performNameDirectEdit();
				} else if (EntityBaseDirectEditUtil.directEditIdentifierHitTest(location, getEntityBaseFigure())) {
//					performIdentifierDirectEdit();
					IFigure figure = EntityBaseDirectEditUtil.getDirectEditIdentifierHitTest(location, getEntityBaseFigure());
					performIdentifierDirectEdit(figure);
				}
				
			} else {
				System.out.println("!DirectEditRequest");
				performNameDirectEdit();
			}
		}
	} 
	
	private void performIdentifierDirectEdit() {
		System.out.println("EntityBaseEditPart.performIdentifierDirectEdit()");
		if (identifierDirectManager == null) {
			EntityBaseFigure entity = getEntityBaseFigure();
			identifierDirectManager = new EntityBaseIdentifierDirectEditManager(this, TextCellEditor.class, new EntityBaseIdentifierCellEditorLocator(entity.getIdentifier()));
		}
		identifierDirectManager.show();
	}

	private void performIdentifierDirectEdit(IFigure figure) {
		System.out.println("EntityBaseEditPart.performIdentifierDirectEdit(IFigure)");
//		if (identifierDirectManager == null) {
//			EntityBaseFigure entity = getEntityBaseFigure();
//			identifierDirectManager = new EntityBaseIdentifierDirectEditManager(this, TextCellEditor.class, new EntityBaseIdentifierCellEditorLocator(entity.getIdentifier()));
//		}
		identifierDirectManager = new EntityBaseIdentifierDirectEditManager(this, TextCellEditor.class, new EntityBaseIdentifierCellEditorLocator(figure), figure);
		identifierDirectManager.show();
	}

	private EntityBaseFigure getEntityBaseFigure() {
		return (EntityBaseFigure) getFigure();
	}
	private void performNameDirectEdit() {
		System.out.println("EntityBaseEditPart.performNameDirectEdit()");
		if (nameDirectManager == null) {
			EntityBaseFigure entity = getEntityBaseFigure();
			nameDirectManager = new EntityBaseNameDirectEditManager(this, TextCellEditor.class, new EntityBaseNameCellEditorLocator(entity.getEntityName()));
		}
		nameDirectManager.show();
	}
	private void performTypeDirectEdit() {
		System.out.println("EntityBaseEditPart.performTypeDirectEdit()");
		if (typeDirectManaget == null) {
			EntityBaseFigure entity = getEntityBaseFigure();
			typeDirectManaget = new EntityBaseTypeDirectEditManager(this, EntityTypeCellEditor.class, new EntityBaseTypeCellEditorLocator(entity.getEntityType()), new String[]{"R","E"});
		}
		typeDirectManaget.show();
	}

}
