/**
 * 
 */
package ter.diagram.editor.directedit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Text;

/**
 * @author ctc
 *
 */
public class EntityBaseIdentifierCellEditorLocator implements CellEditorLocator {

	private IFigure figure;
	
	public EntityBaseIdentifierCellEditorLocator(IFigure figure) {
		System.out.println("EntityBaseIdentifierCellEditorLocator()");
		this.figure = figure;
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gef.tools.CellEditorLocator#relocate(org.eclipse.jface.viewers.CellEditor)
	 */
	public void relocate(CellEditor cellEditor) {
		System.out.println("EntityBaseIdentifierCellEditorLocator.relocate()");
		Text text = (Text)cellEditor.getControl();
		Rectangle rect = figure.getBounds().getCopy();
		figure.translateToAbsolute(rect);
		Rectangle prect = figure.getParent().getBounds().getCopy();
		text.setBounds(rect.x, rect.y, prect.width, rect.height);
	}

}
