/*
   This file is provided under the LGPL license ver 2.1.
   Written by Katsumi.
   http://hp.vector.co.jp/authors/VA016157/
   kmorimatsu@users.sourceforge.jp
*/

#include <xc.h>
#include "compiler.h"
#include "lib_video_megalopa.h"
#include "ps2keyboard.h"

/*
	int readbuttons();
	Read the tact switches.
	For Zoea, disable PS/2 keyboard and enable tact switches, then read.
*/

int readbuttons(){
	return KEYPORT;
}

/*
	void scroll(int x, int y);
	Scroll 
*/

void scroll(int x,int y){
	int i,j;
	int vector=y*twidth+x;
	if (vector<0) {
		// Copy data from upper address to lower address
		for(i=0-vector;i<twidth*WIDTH_Y;i++){
			TVRAM[i+vector]=TVRAM[i];
			TVRAM[twidth*WIDTH_Y+i+vector]=TVRAM[twidth*WIDTH_Y+i];
		}
	} else if (0<vector) {
		// Copy data from lower address to upper address
		for(i=twidth*WIDTH_Y-vector-1;0<=i;i--){
			TVRAM[i+vector]=TVRAM[i];
			TVRAM[twidth*WIDTH_Y+i+vector]=TVRAM[twidth*WIDTH_Y+i];
		}
	} else {
		return;
	}
	if (x<0) {
		// Fill blanc at right
		for(i=x;i<0;i++){
			for(j=twidth+i;j<twidth*WIDTH_Y;j+=twidth){
				TVRAM[j]=0x00;
				TVRAM[twidth*WIDTH_Y+j]=cursorcolor;
			}
		}
	} else if (0<x) {
		// Fill blanc at left
		for(i=0;i<x;i++){
			for(j=i;j<twidth*WIDTH_Y;j+=twidth){
				TVRAM[j]=0x00;
				TVRAM[twidth*WIDTH_Y+j]=cursorcolor;
			}
		}
	}
	if (y<0) {
		// Fill blanc at bottom
		for(i=twidth*(WIDTH_Y+y);i<twidth*WIDTH_Y;i++){
				TVRAM[i]=0x00;
				TVRAM[twidth*WIDTH_Y+i]=cursorcolor;
		}
	} else if (0<y) {
		// Fill blanc at top
		for(i=0;i<twidth*y;i++){
				TVRAM[i]=0x00;
				TVRAM[twidth*WIDTH_Y+i]=cursorcolor;
		}
	}
}

void allocate_graphic_area(){
	if (!g_graphic_area) {
		// Use this pointer like unsigned short GVRAM[G_H_WORD*G_Y_RES] __attribute__ ((aligned (4)));
		g_graphic_area=alloc_memory(X_RESZ*Y_RESZ/8,ALLOC_GRAPHIC_BLOCK);
		// Move current point to (0,0)
//		g_prev_x=g_prev_y=0;
	}
}


void usegraphic(int mode){
	// Modes; 0: stop GRAPHIC, 1: use GRAPHIC, 2: reset GRAPHIC and use it
	switch(mode){
		case 0:
			if (g_use_graphic){
				// Stop music before changing CPU speed
				stop_music();
				// Stop GRAPHIC if used
				set_graphmode(0);
				g_use_graphic=0;
			} else {
				// Prepare GRAPHIC area if not used and not allcated.
				allocate_graphic_area();
			}
			break;
		case 2:
			// Reset GRAPHIC and use it
			g_graphic_area=0;
			// Continue to case 1:
		case 1:
		case 3:
		default:
			// Use GRAPHIC
			allocate_graphic_area();
			// Start showing GRAPHIC with mode 1, but not with mode 3
			if (mode !=3 && !g_use_graphic){
				// Stop music before changing CPU speed
				stop_music();
				// Change to graphic mode.
				set_graphmode(1);
				g_use_graphic=1;
			}
			break;
	}
}

void videowidth(int width){
	// TODO: must do something here

}

void set_graphmode(unsigned char m){
	if (m==0) set_videomode(VMODE_T30,0);
}
