// vim: foldmethod=marker commentstring=//%s
package mygame;

import com.jme3.asset.DesktopAssetManager;
import com.jme3.export.binary.BinaryExporter;
import com.jme3.scene.plugins.ogre.MeshLoader;
import com.jme3.scene.plugins.ogre.MaterialLoader;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.font.plugins.BitmapFontLoader;
import com.jme3.texture.plugins.AWTLoader;
import com.jme3.material.plugins.J3MLoader;
import com.jme3.scene.plugins.ogre.SkeletonLoader;
import com.jme3.asset.plugins.ZipLocator;
import com.jme3.scene.AssetLinkNode;
import com.jme3.asset.ModelKey;
import java.io.File;

public class DressUtil
{//{{{
	static DesktopAssetManager createAssetManager()
	{//{{{
		DesktopAssetManager ass_ = new DesktopAssetManager();
		ass_.registerLoader( MeshLoader.class, "mesh.xml" );
		ass_.registerLoader( MaterialLoader.class, "material" );
		ass_.registerLoader( SkeletonLoader.class, "skeleton.xml" );
		ass_.registerLoader( AWTLoader.class, "png" );
		ass_.registerLoader( AWTLoader.class, "jpg" );
		ass_.registerLoader( AWTLoader.class, "gif" );
		ass_.registerLoader( J3MLoader.class, "j3md" );
		return ass_;
	}//}}}
	public static void main( String[] args_ ) throws Exception
	{//{{{
		// args_ 
		// 0 : output j3o file
		// 1 : input zip file
		// 2 : input main j3o file
		// 3,4... : boneName, sub j3o file ...
		if( args_.length < 3 ){
			throw new Error();
		}
		if( args_.length % 2 != 1 ){
			throw new Error();
		}
		String outFileStr_ = args_[0];
		String zipFileStr_ = args_[1];
		String j3oFileStr_ = args_[2];

		DesktopAssetManager ass_ = createAssetManager();
		ass_.registerLocator( zipFileStr_, ZipLocator.class );
		DressControl ctrl_ = new DressControl();
		for( int i_ = 3; i_ < args_.length; i_ += 2 ){
			String boneName_ = args_[i_];
			String j3oStr_ = args_[i_+1];
			ctrl_.attachChild( boneName_, j3oStr_ );
		}
		AssetLinkNode j3oNode_ = new AssetLinkNode( new ModelKey( j3oFileStr_ ) );
		j3oNode_.addControl( ctrl_ );

		BinaryExporter exp_ = BinaryExporter.getInstance();
		exp_.save( j3oNode_, new File( outFileStr_ ) );
	}//}}}
}//}}}
