/*
 * $Id: translated_game.c,v 1.7 2017/01/08 16:20:00 localhost Exp $
 */
/*
Copyright (c) 2017, k_mia
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

//#define USE_LITTLE_ENDIAN

//#define USE_LAPTIME
#ifdef USE_LAPTIME
#include <sys/time.h>
#include <time.h>
int get_time() {
	static struct timeval last_tv;
	struct timeval tv;
	//struct timezone tz;

	if (gettimeofday(&tv, NULL)) {
		return -1;
	}
	if (timerisset(&last_tv)) {
		// 2nd or later
		unsigned long ss, us;
		if (last_tv.tv_usec>tv.tv_usec) {
			us=1000000+tv.tv_usec-last_tv.tv_usec;
			ss=tv.tv_sec-last_tv.tv_sec-1;
		}
		else {
			us=tv.tv_usec-last_tv.tv_usec;
			ss=tv.tv_sec-last_tv.tv_sec;
		}
		//return (ss*100+us/10000);
		return (ss*10+us/100000);
	}
	else {
		// 1st time
		last_tv=tv;
		return 0;
	}
}
int asmsub(int adr) {
	if (adr==0xFFE8) { return get_time(); }
	return 0;
}
#else //-USE_LAPTIME
int asmsub(int adr) { return 0; }
#endif //-USE_LAPTIME

#define MAXMEM (1024*64) /*must be powers of 2*/
#define POKEB(idx,ofs,val) mainmem[((idx)+(ofs))&(MAXMEM-1)]=(val)
#define PEEKB(idx,ofs) mainmem[((idx)+(ofs))&(MAXMEM-1)]
#ifdef USE_LITTLE_ENDIAN
#define POKEW(idx,ofs,val) addr=mainmem+(((idx)+(ofs)*2)&(MAXMEM-1));value=(val);*(addr)=value;addr=mainmem+(((idx)+(ofs)*2+1)&(MAXMEM-1));*(addr)=value>>8
#define PEEKW(idx,ofs) (mainmem[((idx)+(ofs)*2)&(MAXMEM-1)]+(mainmem[((idx)+(ofs)*2+1)&(MAXMEM-1)]<<8))
#else //-USE_LITTLE_ENDIAN
#define POKEW(idx,ofs,val) addr=mainmem+(((idx)+(ofs)*2)&(MAXMEM-1));value=(val);*(addr)=value>>8;addr=mainmem+(((idx)+(ofs)*2+1)&(MAXMEM-1));*(addr)=value
#define PEEKW(idx,ofs) ((mainmem[((idx)+(ofs)*2)&(MAXMEM-1)]<<8)+mainmem[((idx)+(ofs)*2+1)&(MAXMEM-1)])
#endif //-USE_LITTLE_ENDIAN
#define ABS(v) ((v)<0?-(v):(v))
unsigned char mainmem[MAXMEM];
short A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z;
unsigned char *addr;
unsigned short value;
unsigned short modulo_value;
volatile unsigned short dummy;
unsigned short modulo(short xx) { dummy=xx; return modulo_value; }
//unsigned short division(short v, short d) { int q=v/d; modulo_value=v-d*q; return q; }
short division(short v, short d) { short q=abs(v)/abs(d); modulo_value=abs(v)%abs(d); return (((v<0&&d>0)||(v>=0&&d<0))?-q:q); }
unsigned short asmsub_value;
/* GAMEIII original
unsigned short randseed;
void setrandom(unsigned short v) { randseed=v; }
unsigned short myrandom(unsigned short v) { randseed=randseed*0x3D09+1; return(randseed%v +1);}
*/
void setrandom(unsigned short v) { srand(v); }
unsigned short myrandom(unsigned short v) { return(rand()%v +1);}

#define USE_TERMIO
#ifdef USE_TERMIO
#include <sys/types.h>
#include <termios.h>
#include <unistd.h>
int getachr()
{
	int fd=STDIN_FILENO;
	int n;
	unsigned char buf[2];
	struct termios cur_tio;
	struct termios tmp_tio;
	tcgetattr(fd,&cur_tio);
	tmp_tio=cur_tio;
	tmp_tio.c_lflag&= ~ECHO;
	tmp_tio.c_lflag&= ~ICANON;
	tcsetattr(fd,TCSANOW,&tmp_tio);
	n=read(fd,buf,1);
	tcsetattr(fd,TCSANOW,&cur_tio);
	if (n!=1) {
		return -1;
	}
	return buf[0];
}
#else //-USE_TERMIO
int getachr() { return getchar(); }
#endif //-USE_TERMIO
char* getaline(fd) int fd; {
	static char buf[256];
	memset(buf,0,sizeof(buf));
	if (fgets(buf,sizeof(buf)-1,stdin)==NULL) {
		// error
		return NULL;
	}
	return buf;
}
#define IS_HEXCHR(c) ( ('0'<=(c)&&(c)<='9')|| ('A'<=(c)&&(c)<='F')|| ('a'<=(c)&&(c)<='f') )
int _getahex(c) int c; {
	if ('0'<=(c)&&(c)<='9') { return c-'0'; }
	if ('A'<=(c)&&(c)<='F') { return c-'A'+10; }
	if ('a'<=(c)&&(c)<='f') { return c-'a'+10; }
	return -1;
}
int gethex(p) char* p; {
	int val=0;
	int v;
	for (; (v=_getahex(*p++))>=0; ) {
		val=(val<<4)+v;
	}
	return val;
}
int input() {
	putc(':',stdout); fflush(stdout);
	char* p=getaline(fileno(stdin));
	int val=0;
	if (p==NULL) {
		// error
		return 0;
	}
	if (*p=='-' && p[1]=='$') {
		val= -gethex(p+2);
	}
	else if (*p=='$') {
		val=gethex(p+1);
	}
	else {
		val=atoi(p);
	}
	return val;
}
//===============================================================================

extern int game();
int main(ac,av) int ac; char **av; {
 exit(game(1));
}
void tab(n) int n; { int nn=(n)&0xFF; for(;nn>0;--nn) printf(" "); }
void pr(n,val) int n; int val; { char buf[16]; sprintf(buf,"%d",val); tab(n-strlen(buf)); printf("%s",buf); }
#define LOOP_STACK_MAX 1024
struct {int lino; int val;} loop_stack[LOOP_STACK_MAX];
int loop_stack_top=0;
void push_loop(no,val)
int no;
int val;
{
	loop_stack_top++;
	if (loop_stack_top>=LOOP_STACK_MAX) { printf("ERROR: too deep loop\n"); exit(1); }
	loop_stack[loop_stack_top].lino=no; loop_stack[loop_stack_top].val=val;
}
int peek_loop_value() {
if (loop_stack_top<=0){ printf("ERROR: loop stack underflow\n"); exit(1); }
return loop_stack[loop_stack_top].val;
}
int peek_loop_lino() {
if (loop_stack_top<=0){ printf("ERROR: loop stack underflow\n"); exit(1); }
return loop_stack[loop_stack_top].lino;
}
void pull_loop() {
if (loop_stack_top<=0){ printf("ERROR: loop stack underflow\n"); exit(1); }
loop_stack_top--;
}
int game(lino) int lino; {
 gameloop:
 switch (lino) {


#include "translated_game.gc"


 default:
  return(0);
 }
}

