#!/usr/bin/ruby
# -*- coding: utf-8 -*-

# 
def signed32(i)
  i = i & 0xffffffff
  i = (i < 0x80000000 ? i : i - 0x100000000)
  return i
end

# initialize
arg1 = ARGV.shift
SEED = 20140610
srand(SEED)
N = 1000
t = 1


# output report for .scr
if arg1 == "genscr" then
  print "rpt_add A \"%4t: %32b %32b %64b\\n\" a b out\n"
end

N.times do
  # test cases
  a = rand(0x100000000)
  b = rand(0x100000000)
  
  # result
  out = (signed32(a)*signed32(b)) & 0xffffffffffffffff
  
  # output
  if arg1 == "genscr" then
    print format("set a %032b; set b %032b; forward +1\n", a, b)
  elsif arg1 == "genout" then
    print format("%-4d: %032b %032b %064b\n", t, a, b, out);
  else
    
  end
  
  t = t + 1
end
