﻿using System;
using System.Windows.Forms;

/// <summary>
/// 共通部品
/// </summary>
namespace OfficeImageReducer
{
    /// <summary>
    /// 共通部品クラス
    /// よく使う処理とかオブジェクトを定義
    /// </summary>
    public class ClassMyCommon
    {
        /// <summary>プログラムのタイトル</summary>
        public const string TITLE = "Office Image Reducer";

        /// <summary>プログラムのバージョン</summary>
        public const string VERSION = "04.03-190515";

        /// <summary>プログラム開始時の表示メッセージ</summary>
        public const string OPENING_MSG =
        "Programmed by S.Hori\r\n" +
        "\r\n" +
        "下記のWEBサイトから最新版を入手できます。\r\n" +
        "This software is hosted in the following site.\r\n" +
        "https://ja.osdn.net/users/hor931101jp/pf/01\r\n" +
        "下記のSVNリポジトリからソースコードをチェックアウトできます。\r\n" +
        "Anonymous access will allow anyone to download the source code.\r\n" +
        "svn://svn.pf.osdn.jp/h/ho/hor931101jp/01/tags\r\n" +
        "\r\n" +
        "ここに docx xlsx pptx ファイルをドラックアンドドロップしてください。\r\n" +
        "Please drag and drop docx, xlsx, pptx files here.\r\n";

        /// <summary>メインフォームのインスタンス</summary>
        public static Form frmMain;

        /// <summary>ログのインスタンス</summary>
        static public ClassLog Log;

        /// <summary>
        /// Application.DoEventsとThread.Sleepをしながら待機処理
        /// </summary>
        /// <param name="WaitTime">待ち時間[ms]</param>
        static public void WaitTickCount(Int32 WaitTime)
        {
            Int64 StartTickCount = Environment.TickCount;
            Int64 NowTickCount;
            do
            {
                Application.DoEvents();
                System.Threading.Thread.Sleep(1);
                NowTickCount = Environment.TickCount;
            }
            while ((NowTickCount - StartTickCount) < WaitTime);
        }

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern bool DrawMenuBar(IntPtr hWnd);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern bool RemoveMenu(IntPtr hMenu, uint uPosition, uint uFlags);

        /// <summary>
        /// フォームの右上ボタンと左上メニューのカスタマイズ
        /// フォーム右上ボタンのうち[x]ボタンを無効化する
        /// 左上メニューの[閉じる]を非表示
        /// </summary>
        /// <param name="f">対象とするフォーム</param>
        public static void FormControlBoxCustomize(Form f)
        {
            //const uint SC_SIZE = 0xF000;      //システムメニューの「サイズ変更」
            //const uint SC_MOVE = 0xF010;      //システムメニューの「移動」
            //const uint SC_MINIMIZE = 0xF020;  //システムメニューの「最小化」
            //const uint SC_MAXIMIZE = 0xF030;  //システムメニューの「最大化」
            const uint SC_CLOSE = 0xF060;     //システムメニューの「閉じる」
            //const uint SC_RESTORE = 0xF120;   //システムメニューの「元のサイズに戻す」
            const uint MF_BYCOMMAND = 0x0;    //メニュー項目指定
            const uint MF_BYPOSITION = 0x400; //ポジション指定
            //const uint MF_ENABLED = 0x0;      //有効化
            //const uint MF_GRAYED = 0x1;       //無効化
            //const uint MF_DISABLED = 0x2;     //半無効化(見かけ上有効)
            bool DUMMY;

            //「区切り線」の削除
            DUMMY = RemoveMenu(GetSystemMenu(f.Handle, false), 5, MF_BYPOSITION);
            //「閉じる」の削除 + ｘボタンの無効化
            DUMMY = RemoveMenu(GetSystemMenu(f.Handle, false), SC_CLOSE, MF_BYCOMMAND);
            //描画(変更を反映)
            DUMMY = DrawMenuBar(f.Handle);
        }

        /// <summary>
        /// 自身の exe ファイルの存在するフォルダをフルパスで返す
        /// </summary>
        /// <returns>戻り値（パス）は最後に '\' 付き</returns>
        public static string AppPath()
        {
            return System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + "\\";
        }

        /// <summary>
        /// 文字列を渡して先頭から指定した長さだけの文字列を切り出して返す
        /// BASICに昔からある Left$ 関数
        /// </summary>
        /// <param name="str">文字列</param>
        /// <param name="len">長さ</param>
        /// <returns>切り出した文字列</returns>
        public static string Left(string str, int len)
        {
            if (len < 0)
            {
                throw new ArgumentException("引数'len'は0以上でなければなりません。");
            }
            if (str == null)
            {
                return "";
            }
            if (str.Length <= len)
            {
                return str;
            }
            return str.Substring(0, len);
        }

        /// <summary>
        /// 文字列の末尾から指定した長さの文字列を取得する
        /// BASICに昔からある Right$ 関数
        /// </summary>
        /// <param name="str">文字列</param>
        /// <param name="len">長さ</param>
        /// <returns>切り出した文字列</returns>
        public static string Right(string str, int len)
        {
            if (len < 0)
            {
                throw new ArgumentException("引数'len'は0以上でなければなりません。");
            }
            if (str == null)
            {
                return "";
            }
            if (str.Length <= len)
            {
                return str;
            }
            return str.Substring(str.Length - len, len);
        }
    }
}