﻿/***********************************************************//*!
 * @brief 共通部品
 * @details
 **************************************************************/
using System;
using System.Windows.Forms;

namespace OfficeImageReducer
{
    /***********************************************************//*!
     * @brief 共通部品クラス
     * @details よく使う処理とかオブジェクトを定義
     **************************************************************/
    internal class ClassMyCommon
    {
        //! プログラムのタイトル
        public const string TITLE = "Office Image Reducer";

        //! プログラムのバージョン
        public const string VERSION = "04.01-190215";

        //! プログラム開始時の表示メッセージ
        public const string OPENING_MSG =
        "Programmed by S.Hori\r\n" +
        "\r\n" +
        "下記のWEBサイトから最新版を入手できます。\r\n" +
        "This software is hosted in the following site.\r\n" +
        "https://ja.osdn.net/users/hor931101jp/pf/01\r\n" +
        "下記のSVNリポジトリからソースコードをチェックアウトできます。\r\n" +
        "Anonymous access will allow anyone to download the source code.\r\n" +
        "svn://svn.pf.osdn.jp/h/ho/hor931101jp/01/tags\r\n" +
        "\r\n" +
        "ここに docx xlsx pptx ファイルをドラックアンドドロップしてください。\r\n" +
        "Please drag and drop docx, xlsx, pptx files here.\r\n";

        //! メインフォームのインスタンス
        public static Form frmMain;

        //! ログのインスタンス
        public static ClassLog Log;

        /***********************************************************//*!
         * @brief 待機処理
         * @param[in] WaitTime 待ち時間[ms]
         * @details Application.DoEventsとThread.Sleepをしながら待機
         **************************************************************/
        static public void WaitTickCount(Int32 WaitTime)
        {
            Int64 StartTickCount = Environment.TickCount;
            Int64 NowTickCount;
            do
            {
                Application.DoEvents();
                System.Threading.Thread.Sleep(1);
                NowTickCount = Environment.TickCount;
            }
            while ((NowTickCount - StartTickCount) < WaitTime);
        }

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern IntPtr GetSystemMenu(IntPtr hWnd, bool bRevert);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern bool DrawMenuBar(IntPtr hWnd);

        [System.Runtime.InteropServices.DllImport("user32.dll")]
        private static extern bool RemoveMenu(IntPtr hMenu, uint uPosition, uint uFlags);

        /***********************************************************//*!
         * @brief フォームの右上ボタンと左上メニューのカスタマイズ
         * @param[in] f 対象とするフォーム
         * @details フォーム右上ボタンのうち[x]ボタンを無効化する。
         *          左上メニューの[閉じる]を消去
         **************************************************************/
        public static void FormControlBoxCustomize(Form f)
        {
            //const uint SC_SIZE = 0xF000;      //システムメニューの「サイズ変更」
            //const uint SC_MOVE = 0xF010;      //システムメニューの「移動」
            //const uint SC_MINIMIZE = 0xF020;  //システムメニューの「最小化」
            //const uint SC_MAXIMIZE = 0xF030;  //システムメニューの「最大化」
            const uint SC_CLOSE = 0xF060;     //システムメニューの「閉じる」
            //const uint SC_RESTORE = 0xF120;   //システムメニューの「元のサイズに戻す」
            const uint MF_BYCOMMAND = 0x0;    //メニュー項目指定
            const uint MF_BYPOSITION = 0x400; //ポジション指定
            //const uint MF_ENABLED = 0x0;      //有効化
            //const uint MF_GRAYED = 0x1;       //無効化
            //const uint MF_DISABLED = 0x2;     //半無効化(見かけ上有効)
            bool DUMMY;

            //「区切り線」の削除
            DUMMY = RemoveMenu(GetSystemMenu(f.Handle, false), 5, MF_BYPOSITION);
            //「閉じる」の削除 + ｘボタンの無効化
            DUMMY = RemoveMenu(GetSystemMenu(f.Handle, false), SC_CLOSE, MF_BYCOMMAND);
            //描画(変更を反映)
            DUMMY = DrawMenuBar(f.Handle);
        }

        /***********************************************************//*!
         * @brief 自身の exe ファイルの存在するパスを返す
         * @return 戻り値（パス）は最後に '\' 付き
         **************************************************************/
        public static string AppPath()
        {
            return System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().Location) + "\\";
        }

        /***********************************************************//*!
         * @brief 文字列を渡して先頭から指定した長さだけの文字列を切り出して返す
         * @param[in] str 文字列
         * @param[in] len 長さ
         * @return 切り出した文字列
         * @details BASICに昔からある Left$ 関数
         **************************************************************/
        public static string Left(string str, int len)
        {
            if (len < 0)
            {
                throw new ArgumentException("引数'len'は0以上でなければなりません。");
            }
            if (str == null)
            {
                return "";
            }
            if (str.Length <= len)
            {
                return str;
            }
            return str.Substring(0, len);
        }

        /***********************************************************//*!
         * @brief 文字列の末尾から指定した長さの文字列を取得する
         * @param[in] str 文字列
         * @param[in] len 長さ
         * @return 切り出した文字列
         * @details BASICに昔からある Right$ 関数
         **************************************************************/
        public static string Right(string str, int len)
        {
            if (len < 0)
            {
                throw new ArgumentException("引数'len'は0以上でなければなりません。");
            }
            if (str == null)
            {
                return "";
            }
            if (str.Length <= len)
            {
                return str;
            }
            return str.Substring(str.Length - len, len);
        }
    }
}