package model;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;

import meta.ClassMetaColumn;
import meta.ClassMetaObject;
import meta.MetaColumn;
import meta.MetaFactory;

import common.DBAccessWrapper;

/**
 *
 * @author 無糖ブラック
 *
 */
public class ModelObject {

	/**
	 *
	 */
	protected DBAccessWrapper m_db;

	/**
	 *
	 */
	protected String m_tableName;

	/**
	 *
	 */
	protected HashMap<String, String> m_properties;

	/**
	 *
	 */
	public ModelObject() {
		this.m_db = null;
	}

	/**
	 *
	 * @param db
	 * @param keys
	 * @param values
	 * @throws IOException
	 */
	public ModelObject(DBAccessWrapper db, ArrayList<String> keys, ArrayList<String> values, String tableName) {
		this.m_db = db;
		this.m_tableName = tableName;
		this.m_properties = new HashMap<String, String>();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		ArrayList<MetaColumn> metaColumns = classMetaColumn.getMetaObjects(m_tableName);

		for( int ii = 0; ii < keys.size(); ++ii ) {
			String key = keys.get(ii);
			key = key.toUpperCase();
			int pos = key.indexOf(" AS ");
			if ( pos >= 0) {
				key = key.substring(pos + 4, key.length());
			}
			String value = values.get(ii);
			if ( value == null ) {
				value = "";
			}

			for (int jj = 0; jj < metaColumns.size(); ++jj) {
				MetaColumn metaColumn = metaColumns.get(jj);
				String columnId = metaColumn.getProperty("COLUMN_ID");
				if ( columnId.equals(key) ) {
					String columnType = metaColumn.getProperty("COLUMN_TYPE");
					if( columnType.equals("BOOLEAN") ) {
						if ( value.equals("t") ) {
							value = "TRUE";
						}
						else {
							value = "FALSE";
						}
					}
					break;
				}
			}

			m_properties.put(key, value);
		}
	}

	/**
	 *
	 * @return
	 */
	public String identification() {
		return m_properties.get("IDENTIFICATION");
	}

	/**
	 *
	 * @return
	 * @throws IOException
	 */
	public String getProperty(String name) throws IOException {
		String value;
		name = name.toUpperCase();
		value = m_properties.get(name);
		return value;
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 */
	public int setProperty(String name, String value) throws SQLException, ClassNotFoundException {

		name = name.toUpperCase();

		MetaFactory metaFactory = MetaFactory.getMetaFactory();
		ClassMetaObject classMetaObject = metaFactory.getClassMetaObject("MetaColumn");
		ClassMetaColumn classMetaColumn = (ClassMetaColumn)classMetaObject;
		MetaColumn metaColumn = classMetaColumn.getMetaObjects(m_tableName, name);
		String type = metaColumn.getProperty("COLUMN_TYPE");

		ArrayList<String> updateParams = new ArrayList<String>();
		ArrayList<String> updateTypes  = new ArrayList<String>();
		ArrayList<Object> updateValues  = new ArrayList<Object>();

		updateParams.add(name);
		updateTypes.add(type);
		updateValues.add(value);

		String updateCondition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identification());

		int result = m_db.update(updateParams, updateTypes, updateValues, m_tableName, updateCondition, conditionTypes, conditionValues);
		if (result < 0) {
			return result;
		}
		m_properties.put(name, value);
		return result;
	}

	/**
	 *
	 * @return
	 * @throws SQLException
	 * @throws ClassNotFoundException
	 * @throws IOException
	 */
	public int delete() throws SQLException, ClassNotFoundException, IOException {

		String deleteCondition = "identification = ?";
		ArrayList<String> conditionTypes = new ArrayList<String>();
		ArrayList<Object> conditionValues = new ArrayList<Object>();
		conditionTypes.add("int");
		conditionValues.add(identification());

		return m_db.delete(m_tableName, deleteCondition, conditionTypes, conditionValues);
	}
}
