﻿Public Class frmOperation

#Region "初期処理"


    Private Sub frmOperation_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        screenDetect()
        AppSettingLoad()
        ActivateForm()
    End Sub

    Private Sub ActivateForm()

        Timer1.Interval = 100
        Timer1.Start()
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        Me.Activate()
        Timer1.Stop()
    End Sub

#Region "設定値"
    Private loading As Boolean
    Private Sub AppSettingLoad()
        loading = True
        cmbDisplay.SelectedIndex = My.Settings.cmbDisplaySelectedIndex
        Try
            Dim fvinfos As New List(Of FileViewParam)

            'XmlSerializerオブジェクトを作成
            Dim serializer As New System.Xml.Serialization.XmlSerializer(
                GetType(List(Of FileViewParam)))
            '読み込むファイルを開く
            Using sr As New System.IO.StreamReader(
                "lstPDFFiles.xml", New System.Text.UTF8Encoding(False))
                'XMLファイルから読み込み、逆シリアル化する
                fvinfos =
                DirectCast(serializer.Deserialize(sr), List(Of FileViewParam))
                'ファイルを閉じる
            End Using
            For Each info In fvinfos
                lstPDFFiles.Items.Add(info)
            Next
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try
        loading = False
    End Sub

    Private Sub AppSettingSave()

        My.Settings.cmbDisplaySelectedIndex = cmbDisplay.SelectedIndex
        My.Settings.Save()

        Dim fvinfos As New List(Of FileViewParam)
        For Each info In lstPDFFiles.Items
            fvinfos.Add(info)
        Next
        Dim serializer As New System.Xml.Serialization.XmlSerializer(
            GetType(List(Of FileViewParam)))
        '書き込むファイルを開く（UTF-8 BOM無し）
        Using sw As New System.IO.StreamWriter(
            "lstPDFFiles.xml", False, New System.Text.UTF8Encoding(False))
            'シリアル化し、XMLファイルに保存する
            serializer.Serialize(sw, fvinfos)
            'ファイルを閉じる
        End Using
    End Sub

#End Region

    Private Sub screenDetect()
        'デバイス名が表示されるようにする
        Me.cmbDisplay.DisplayMember = "DeviceName"
        Me.cmbDisplay.DataSource = Screen.AllScreens

    End Sub
#End Region

#Region "終了処理"

    Private Sub frmOperation_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        AppSettingSave()
        _dispacher.Close()

    End Sub
#End Region

#Region "フォームをセカンドディスプレイに表示"
    Private Sub cmbDisplay_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbDisplay.SelectedIndexChanged

        If cmbDisplay.SelectedIndex < 0 Then
            Exit Sub
        End If
        If cmbDisplay.SelectedItem Is Nothing Then
            Exit Sub
        End If
        '        'フォームを表示するディスプレイのScreenを取得する
        Dim s As Screen = DirectCast(Me.cmbDisplay.SelectedItem, Screen)
        '        'フォームの開始位置をディスプレイの左上座標に設定する
        _dispacher.SetSecondScreen(s)




    End Sub



    Private _dispacher As FormDispacher = FormDispacher.GetInstance


#End Region





    Private Sub tbcFileOpes_SelectedIndexChanged(sender As Object, e As EventArgs) Handles tbcFileOpes.SelectedIndexChanged
        'If tbcFileOpes.SelectedTab Is tpAdobePDF Then
        '    frmView.pnlCover.Visible = False
        '    frmView.UserControl11.Visibility = Windows.Visibility.Hidden
        '    StopVideo()
        'Else
        '    frmView.pnlCover.Visible = True
        '    frmView.UserControl11.Visibility = Windows.Visibility.Visible
        'End If

    End Sub

    'Private Sub NumericUpDown1_ValueChanged(sender As Object, e As EventArgs) Handles nudHeight.ValueChanged
    '    frmView.Height = nudHeight.Value

    'End Sub

    'Private Sub NumericUpDown2_ValueChanged(sender As Object, e As EventArgs) Handles nudWidth.ValueChanged
    '    frmView.Width = nudWidth.Value
    'End Sub



#Region "リストボックス処理"



    Private Sub btnDelete_Click(sender As Object, e As EventArgs) Handles btnDelete.Click
        If lstPDFFiles.SelectedItem Is Nothing Then
            Exit Sub
        End If
        Dim fileviewinfo As FileViewParam
        fileviewinfo = lstPDFFiles.SelectedItem
        lstPDFFiles.Items.Remove(fileviewinfo)
    End Sub





    Private Sub lstPDFFiles_Click(sender As Object, e As EventArgs) Handles lstPDFFiles.Click
        Dim fileviewinfo As FileViewParam
        fileviewinfo = lstPDFFiles.SelectedItem
        If fileviewinfo Is Nothing Then
            Exit Sub
        End If
        txtPDFFileName.Text = fileviewinfo.FileName
        Dim ext = IO.Path.GetExtension(fileviewinfo.FileName).ToLower()
        If ext = ".pdf" Then
            tbcFileOpes.SelectTab(tpAdobePDF.TabIndex)
            CtlPdf1.SetFileInfo(fileviewinfo)

        ElseIf IsImageExt(ext) Then
            tbcFileOpes.SelectTab(tpImage.TabIndex)
            CtlImage1.SetFileInfo(fileviewinfo)
            _dispacher.ShowImage()
        ElseIf IsMovieExt(ext) Then
            tbcFileOpes.SelectTab(tpMediaPlayer.TabIndex)
            CtlMovie1.SetFileInfo(fileviewinfo)
        End If
    End Sub

    Private Function IsImageExt(ext) As Boolean
        Dim imageExt = {".jpeg", ".jpg", ".bmp", ".png"}
        Return imageExt.Contains(ext)
    End Function

    Private Function IsMovieExt(ext) As Boolean
        Dim movieExt = {".avi", ".mpeg", ".mp4", ".wmv"}
        Return movieExt.Contains(ext)
    End Function





    Private Sub Button1_Click(sender As Object, e As EventArgs)


    End Sub

    Private Sub Button2_Click(sender As Object, e As EventArgs) Handles Button2.Click
        OpenFileDialog1.Multiselect = True
        OpenFileDialog1.Filter = "画像、動画、PDFファイル|*.pdf;*.bmp;*.gif;*.png;|All Files(*.*)|*.*;"
        OpenFileDialog1.FileName = txtPDFFileName.Text
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If

        Dim items = lstPDFFiles.Items

        For Each filename In OpenFileDialog1.FileNames
            items.Add(New FileViewParam(filename))
        Next


    End Sub






#End Region

End Class