﻿Imports System.Windows.Forms



Public Class frmOperation

#Region "初期処理"

    Public Property frmView As frmView
    Public Property axPDF As AxAcroPDFLib.AxAcroPDF

    Private Sub frmOperation_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        screenDetect()
        AppSettingLoad()
        ActivateForm()
    End Sub

    Private Sub ActivateForm()

        Timer1.Interval = 100
        Timer1.Start()
    End Sub

    Private Sub Timer1_Tick(sender As Object, e As EventArgs) Handles Timer1.Tick
        Me.Activate()
        Timer1.Stop()
    End Sub

#Region "設定値"
    Private Sub AppSettingLoad()

        cmbDisplay.SelectedIndex = My.Settings.cmbDisplaySelectedIndex
        cmbPDFView.SelectedIndex = My.Settings.cmbView
    End Sub

    Private Sub AppSettingSave()

        My.Settings.cmbDisplaySelectedIndex = cmbDisplay.SelectedIndex
        My.Settings.cmbView = cmbPDFView.SelectedIndex
        My.Settings.Save()
    End Sub

#End Region

    Private Sub screenDetect()
        'デバイス名が表示されるようにする
        Me.cmbDisplay.DisplayMember = "DeviceName"
        Me.cmbDisplay.DataSource = Screen.AllScreens

    End Sub
#End Region

#Region "終了処理"

    Private Sub frmOperation_FormClosed(sender As Object, e As FormClosedEventArgs) Handles MyBase.FormClosed
        AppSettingSave()
        frmView.Close()
    End Sub
#End Region

#Region "フォームをセカンドディスプレイに表示"
    Private Sub cmbDisplay_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbDisplay.SelectedIndexChanged
        If cmbDisplay.SelectedIndex < 0 Then
            Exit Sub
        End If
        If cmbDisplay.SelectedItem Is Nothing Then
            Exit Sub
        End If
        'フォームを表示するディスプレイのScreenを取得する
        Dim s As Screen = DirectCast(Me.cmbDisplay.SelectedItem, Screen)
        'フォームの開始位置をディスプレイの左上座標に設定する
        frmView.StartPosition = FormStartPosition.Manual
        frmView.Location = s.Bounds.Location
        frmView.Size = s.Bounds.Size
        nudHeight.Value = frmView.Size.Height
        nudWidth.Value = frmView.Size.Width
    End Sub





#End Region

#Region "Adobe PDF Reader の 処理"

#Region "ページ移動"

    Private Sub btnFirst_Click(sender As Object, e As EventArgs) Handles btnPDFFirst.Click
        axPDF.gotoFirstPage()
    End Sub

    Private Sub btnNext_Click(sender As Object, e As EventArgs) Handles btnPDFNext.Click
        axPDF.gotoNextPage()
    End Sub

    Private Sub btnBack_Click(sender As Object, e As EventArgs) Handles btnPDFBack.Click
        axPDF.gotoPreviousPage()
    End Sub

    Private Sub btnLast_Click(sender As Object, e As EventArgs) Handles btnPDFLast.Click
        axPDF.gotoLastPage()
    End Sub

#End Region

    ''' <summary>
    ''' ページのおさまり表示の変更
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub cmbView_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cmbPDFView.SelectedIndexChanged
        If axPDF Is Nothing Then
            Exit Sub
        End If
        axPDF.setView(cmbPDFView.Text)
    End Sub

    Private Sub nudPdfZoom_ValueChanged(sender As Object, e As EventArgs) Handles nudPdfZoom.ValueChanged
        If axPDF Is Nothing Then
            Exit Sub
        End If
        axPDF.setZoom(nudPdfZoom.Value)
    End Sub

    ''' <summary>
    ''' PDFを閉じる
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    Private Sub btnFileClose_Click(sender As Object, e As EventArgs) Handles btnPDFFileClose.Click
        txtPDFFileName.Text = String.Empty
    End Sub



#Region "PDFファイルを開く"
    Private backFileName As String
    Private Sub btnFileOpen_Click(sender As Object, e As EventArgs) Handles btnOpenPDFFile.Click
        OpenFileDialog1.Filter = "PDFファイル (*.pdf) |*.pdf"
        OpenFileDialog1.FileName = txtPDFFileName.Text
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If

        txtPDFFileName.Text = OpenFileDialog1.FileName

    End Sub

    Private Sub txtFileName_TextChanged(sender As Object, e As EventArgs) Handles txtPDFFileName.TextChanged
        If txtPDFFileName.Text = String.Empty Then
            'ファイルを閉じることはできないので非表示にしている。
            frmView.pnlCover.Visible = True

            Return
        End If
        frmView.pnlCover.Visible = False
        If backFileName = txtPDFFileName.Text Then
            Return
        End If
        axPDF.Visible = True
        axPDF.LoadFile(txtPDFFileName.Text)
        'todo : pdfが開けなかったときの処理
        backFileName = txtPDFFileName.Text
        axPDF.setShowToolbar(False)
        axPDF.setShowScrollbars(False)
    End Sub



#End Region
#End Region

#Region "Media Playerの処理"

    Private inPlay As Boolean = False
    Private Sub btnOpenMediaFile_Click(sender As Object, e As EventArgs) Handles btnOpenMediaFile.Click
        OpenFileDialog1.Filter = "映像ファイル (*.wmv;*.mp4)|*.wmv;*.mp4;|画像ファイル(*.jpg)|*.jpg|All Files(*.*)|*.*;"
        OpenFileDialog1.FileName = txtMediaFileName.Text
        Dim ret = OpenFileDialog1.ShowDialog()
        If ret = Windows.Forms.DialogResult.Cancel Then
            Exit Sub
        End If

        txtMediaFileName.Text = OpenFileDialog1.FileName
        Dim ext = System.IO.Path.GetExtension(txtMediaFileName.Text).ToLower()
        If ext = ".jpg" Or ext = ".jpeg" Then
            PlayVideo()
        End If

    End Sub

    Private Sub btnStartStop_Click(sender As Object, e As EventArgs) Handles btnStartStop.Click
        If Not inPlay Then
            PlayVideo()
        Else
            StopVideo()
        End If
    End Sub

    Sub PlayVideo()
        inPlay = True
        frmView.UserControl11.PlayVideo(txtMediaFileName.Text)
        btnStartStop.Text = "停止する"
    End Sub

    Sub StopVideo()
        inPlay = False
        frmView.UserControl11.StopVideo()
        btnStartStop.Text = "再生する"
    End Sub





#End Region

    Private Sub tbcFileOpes_SelectedIndexChanged(sender As Object, e As EventArgs) Handles tbcFileOpes.SelectedIndexChanged
        If tbcFileOpes.SelectedTab Is tpAdobePDF Then
            frmView.pnlCover.Visible = False
            frmView.UserControl11.Visibility = Windows.Visibility.Hidden
            StopVideo()
        Else
            frmView.pnlCover.Visible = True
            frmView.UserControl11.Visibility = Windows.Visibility.Visible
        End If

    End Sub

    Private Sub NumericUpDown1_ValueChanged(sender As Object, e As EventArgs) Handles nudHeight.ValueChanged
        frmView.Height = nudHeight.Value

    End Sub

    Private Sub NumericUpDown2_ValueChanged(sender As Object, e As EventArgs) Handles nudWidth.ValueChanged
        frmView.Width = nudWidth.Value
    End Sub


End Class