require 'open-uri'
require 'erb'
require 'rss'
require 'rexml/document'

class Nicovideo

  def tag_search(tag_name, options = {})
    video_ids = []
    params = { :sort => 'f', :rss => 'atom' }
    params.update(options)
    uri = "http://www.nicovideo.jp/tag/#{ERB::Util.u tag_name}?" + params.map { |name, value| "#{name}=#{value}" }.join('&')
    open(uri) do |f|
      rss = RSS::Parser.parse(f)
      rss.entries.each do |ent|
        if md = %r(/watch/(.+?)\z).match(ent.link.href)
          video_id = md[1]
          video_ids.push video_id
        end
      end
    end
    video_ids
  end

  class ThumbData
    attr_accessor :video_id, :title, :description
  end

  def get_thumbinfo(video_id)
    td = ThumbData.new
    uri = "http://ext.nicovideo.jp/api/getthumbinfo/#{video_id}"
    open(uri) do |f|
      doc = REXML::Document.new(f)
      thumb = doc.root.elements['thumb']
      td.video_id = thumb.elements['video_id'].text
      td.title = thumb.elements['title'].text
      td.description = thumb.elements['description'].text
    end
    td
  end
end
