gem 'zipruby'
require 'zipruby'
require 'nkf'

module Archivers
  class Lzh
    def initialize(path)
      @path = path
    end

    def each_entry
      text = `lha lv #{@path}`
      mode = :head
      StringIO.new(text).each_line do |line|
        case mode
        when :head
          if /\A----/.match(line)
            mode = :flip
            next
          end
        when :flip
          if /\A----/.match(line)
            mode = :tail
            next
          end
          yield line
          mode = :flop
        when :flop
          mode = :flip
        end
      end
    end
  end

  class Rar
    def initialize(path)
      @path = path
    end

    def each_entry
      text = `unrar vb #{@path}`
      StringIO.new(text).each_line do |line|
        yield line
      end
    end
  end

  class Zip
    def initialize(path)
      @path = path
    end

    def encode(str)
      str && NKF.nkf('-Sw', str)
    end

    def each_entry
      ::Zip::Archive.open(@path) do |ar|
        n = ar.num_files # number of entries
        n.times do |i|
          # entry_name = ar.get_name(i) # get entry name from archive

          # open entry
          ar.fopen(i) do |f|
            path = encode(f.name)
            yield path

            # content = f.read # read entry content
          end
        end
      end
    rescue ::Zip::Error => exc
      puts "error: " + exc.message
    end
  end

module_function

  def class_from_extname(extname)
    case extname
    when 'lzh'
      Lzh
    when 'rar'
      Rar
    when 'zip'
      Zip
    end
  end

  def load(path, extname)
    klass = class_from_extname(extname)
    klass.new(path) if klass
  end

end
