#!ruby
# encoding: utf-8
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../app/models')
require 'connection'
require 'site'
require 'arc'
require 'thumb'
require 'nicovideo'

nv = Nicovideo.new

class << nv
  PAGE_SIZE = 30

  def tag_search_and_get_thumbinfo_0(tag_name, options = {})
    video_ids = tag_search(tag_name, options)
    video_ids.each do |video_id|
      puts video_id
      td = get_thumbinfo(video_id)
      thumb = Thumb.find(td.video_id) || Thumb.new(:key => td.video_id)
      thumb.title = td.title
      thumb.description = td.description
      thumb.save
    end
  end

  def tag_search_and_get_thumbinfo(tag_name, size)
    max_page = (size - 1) / PAGE_SIZE + 1
    for page in 1 .. max_page
      tag_search_and_get_thumbinfo_0(tag_name, :page => page, :order => 'a')
    end
  end
end

nv.tag_search_and_get_thumbinfo("MMDデータ配布あり",      264)
nv.tag_search_and_get_thumbinfo("MMDモデル配布あり",     3610)
nv.tag_search_and_get_thumbinfo("MMDモーション配布あり", 1458)
