#!ruby
# encoding: utf-8

require 'yaml'

config_path = File.expand_path('~/.nicovideorc')
config_yaml = File.open(config_path)
config = YAML.load(config_yaml)
p config

require 'mechanize'

agent = Mechanize.new
page = agent.post('https://secure.nicovideo.jp/secure/login?site=niconico', config)
p page.header["x-niconico-authflag"]

tag_name = "MMDアクセサリ配布あり"
page = 1
puts "downloading page: #{page}"
agent.download('http://seiga.nicovideo.jp/api/tagslide/data', 'doc/tagslide.1.xml', page: page, query: tag_name)

require 'rexml/document'

puts "reading page: #{page} to get image_count"
doc = REXML::Document.new(open("doc/tagslide.#{page}.xml"))
image_count = doc.elements['response/image_count'].text.to_i

max_page = (image_count-1)/200+1

for page in 2..max_page
  puts "downloading page: #{page}"
  agent.download('http://seiga.nicovideo.jp/api/tagslide/data', "doc/tagslide.#{page}.xml", page: page, query: tag_name)
end

$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../app/models')
require 'connection'
require 'site'
require 'arc'
require 'seiga'

require 'rexml/document'

Dir.glob('doc/tagslide.?.xml') do |ent|
  puts "reading #{ent}"
  f = open(ent)
  doc = REXML::Document.new(f)
  doc.elements.each('response/image_list/image') do |ele|
    image_id = 'im' + ele.elements['id'].text
    puts image_id
    seiga = Seiga.find(image_id) || Seiga.new(:key => image_id)
    seiga.title = ele.elements['title'].text
    seiga.description = ele.elements['description'].text
    seiga.save
  end
  f.close
end

require 'fileutils'

FileUtils.rm Dir.glob('doc/tagslide.?.xml')
