#!ruby
# encoding: utf-8
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../lib')
$LOAD_PATH.unshift File.expand_path(File.dirname(__FILE__) + '/../app/models')
require 'connection'
require 'site'
require 'arc'
require 'pmd'
require 'vmd'
require 'x'
require 'thumb'
require 'bowl'

site = Site.find('mmdbowl')

Bowl.each_code_in_rss do |code|
  number = /dl(\d+)\z/.match(code)[1].to_i
  bowl = Bowl.new(code)
  bowl.load
  next if bowl.removed? || bowl.denied?

  name = bowl.name
  summary = bowl.summary
  size = '0KB'
  date = '01/01/01(Mon),00:00:00'
  origname = bowl.origname
  locked = bowl.locked?

  arc = site.create_arc(name, summary, size, date, origname, locked)
  arc.create_entries("/Volumes/uploader/arc/#{site.code}/#{name}") unless locked
  puts
end
