// ===================================================================
//  oop.js
// ===================================================================
// 

function copy_undef_properties(src, dest)
{
	for (var prop in src) {
		if (typeof(dest[prop]) == "undefined") { 
			dest[prop] = src[prop];
		}
	}
}

// p֐
function inherit(subClass, superClass) 
{
	copy_undef_properties(superClass.prototype, subClass.prototype);
}

// Ip֐
function dynamic_inherit(instance, dynamicClass, 
						 arg1, arg2, arg3, arg4, arg5,
						 arg6, arg7, arg8, arg9, arg10)
{
	copy_undef_properties(dynamicClass.prototype, instance);
	instance.temp = dynamicClass;
	instance.temp(arg1, arg2, arg3, arg4, arg5, 
				  arg6, arg7, arg8, arg9, arg10); 
	return instance;
}

function copy_properties(src, dest)
{
	for (var prop in src) {
		dest[prop] = src[prop];
	}
}

// IȌp֐
function force_inherit(subClass, superClass) 
{
	copy_properties(superClass.prototype, subClass.prototype);
}

// IȓIp֐
function force_dynamic_inherit(instance, dynamicClass, 
							   arg1, arg2, arg3, arg4, arg5,
							   arg6, arg7, arg8, arg9, arg10)
{
	copy_properties(dynamicClass.prototype, instance);
	instance.temp = dynamicClass;
	instance.temp(arg1, arg2, arg3, arg4, arg5, 
				  arg6, arg7, arg8, arg9, arg10); 
	return instance;
}
  
