<#assign bean_el=JspTaglibs["http://struts.apache.org/tags-bean-el"] />
<#assign html=JspTaglibs["http://struts.apache.org/tags-html-el"] />
<#import "/macro.ftl" as macro />
<#if loginUser?has_content && loginUser.userId == user.userId>
  <#assign key="home" />
<#else>
  <#assign key="people" />
</#if>
<h2><#rt />
<#assign friendCount = user[Session.listRefine.viewType.id] />
<#if Session.listRefine.viewType.friends>
  <@bean_el.message bundle="message.friends" key="following.${key}" arg0=user.foreignKey arg1=friendCount?string /><#t />
<#elseif friendCount == 0>
  <@bean_el.message bundle="message.friends" key="notFollow.${key}" arg0=user.foreignKey /><#t />
<#else>
  <@bean_el.message bundle="message.friends" key="followers.${key}" arg0=user.foreignKey arg1=friendCount?string /><#t />
</#if>
</h2><#lt />
<input type="hidden" name="csrf_ticket" value="${csrf_ticket?default('')}" />
<input type="hidden" name="source" value="web" />
<table class="friendships" cellspacing="0" cellpadding="0">
  <colgroup>
    <col />
    <col />
    <col align="right" width="25px" />
  </colgroup>
  <tbody>
<#if friendships?has_content && friendships?size &gt; 0>
  <#list friendships as friendship>
    <tr<#if !friendship_has_next> class="last"</#if>>
      <td class="thumb"><#rt />
    <#if Session.listRefine.viewType.friends>
      <#assign friend=friendship.passive />
    <#else>
      <#assign friend=friendship.active />
    </#if>
    <@macro.icon page="/${friend.foreignKey}" user=friend size="large" /><#t />
      </td><#lt />
      <td class="desc"><#rt />
        <span class="username"><#t />
          <a href="<@html.rewrite page="/${friend.foreignKey}" />" ><#t />
            <span title="${friend.displayName}">${friend.foreignKey}</span><#t />
          </a><#t />
          &nbsp;/&nbsp;${friend.displayName}<#t />
    <#if friend.protect>
          <img src="<@html.rewrite page="${webroot}/image/lock.png" />" />
    </#if>
        </span><#t />
    <#if loginUser?has_content && friend.userId == loginUser.userId>
        <span class="message"><#t />
          <@bean_el.message bundle="message.friends" key="following.yourself" /><#t />
        </span><#t />
      </td><#lt />
      <td class="actions">&nbsp;</td>
    <#elseif key == "home" && Session.listRefine.viewType.friends>
      <#if friendship.follower?has_content>
        <a href="/direct_messages/create/${friend.foreignKey}" title="Send a direct message to ${friend.foreignKey}"><@bean_el.message bundle="message.friends" key="directMessage" /></a>&nbsp|&nbsp;<#t />
        <a href="/friends/nudge/${friend.foreignKey}" title="Remind ${friend.foreignKey} to update!"><@bean_el.message bundle="message.friends" key="nudge" arg0=friend.foreignKey /></a><#t />
      </#if>
        <span class="notify"><#t />
          <@bean_el.message bundle="message.friends" key="notice" />:&nbsp;<#t />
          <input type="radio" name="notify_${friendship.friendshipId}" value="1" id="notifyOn_${friendship.friendshipId}"<#if friendship.notify> checked="checked"</#if> onclick="shovel.controller.setNotify('${friend.foreignKey}');" />&nbsp;<label for="notifyOn_${friendship.friendshipId}">On</label>&nbsp;<#t />
          <input type="radio" name="notify_${friendship.friendshipId}" value="0" id="notifyOff_${friendship.friendshipId}"<#if !friendship.notify> checked="checked"</#if> onclick="shovel.controller.unsetNotify('${friend.foreignKey}');" />&nbsp;<label for="notifyOff_${friendship.friendshipId}">Off</label><#t />
        </span><#lt />
      </td><#lt />
      <td class="actions"><#rt />
        <input type="button" value="<@bean_el.message bundle="message.friends" key="remove" />" onclick="return shovel.controller.destroyFriendship('${friend.foreignKey}');" id="friends_destroyFriendship_${friend.foreignKey}" /><#t />
      </td><#lt />
    <#else>
        <span class="message" id="friends_friends_${friend.foreignKey}"<#if !friendship.friend?has_content> style="display: none;"</#if>><#t />
          <img src="<@html.rewrite href="${webroot}/image/yes.gif" />" /><@bean_el.message bundle="message.friends" key="following.done" arg0=friend.foreignKey /><#t />
        </span><#t />
      </td><#lt />
      <td class="actions"><#rt />
      <#if friendship.friend?has_content>
          &nbsp;<#t />
      <#else>
          <input type="button" value="<@bean_el.message bundle="message.friends" key="following.request" />" onclick="return shovel.controller.createFriendship('${friend.foreignKey}');"<#if friendship.friend?has_content> style="display: none;"</#if> id="friends_createFriendship_${friend.foreignKey}" /><#t />
      </#if>
      </td><#lt />
    </#if>
    </tr>
  </#list>
</#if>
<@macro.pager nextPage=nextPage handler="getFriendshipsByPage" />
  </tbody>
</table>
