package jp.sourceforge.shovel.service;

import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.SearchFriendsType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;

public interface IShovelService {
    IStatus getStatus(long statusId);
    IStatus getRecent();
    IStatus getRecent(String foreignKey) throws ApplicationException;
    IStatus getRecent(long userId) throws ApplicationException;
    IStatus[] getRecents(long[] userIds);
    IStatus[] getStatuses(int page, int limit);
    IStatus[] getStatuses(long sinceId, int limit);
    IStatus[] getStatuses(String since, boolean useRemoved, int limit) throws ApplicationException;
    IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit);
    //correct*はlimitの補正値
    IStatus[] getStatuses(String foreignKey, boolean withFriends, int page, int limit, int correctedOffset, int correctedLimit) throws ApplicationException;
    IStatus[] getStatuses(String foreignKey, boolean withFriends, String since, int limit) throws ApplicationException;
    IStatus[] getReplies(String foreignKey, int page, int limit) throws ApplicationException;
    IStatus[] getFavorites(String foreignKey, int page, int limit) throws ApplicationException;
    
    IStatusWrapper updateStatus(String status, String source) throws ApplicationException;
    
    int destroyStatus(long statusId) throws ApplicationException;
    
    IStatus[] truncate(IStatus[] statuses, int offset, int limit);
    void prepareForView(IStatus status) throws ApplicationException;
    IStatus[] prepareForView(IStatus[] statuses, int limit, boolean truncate);
    
    void outputFeed(FormatType formatType, ViewType viewType, IUser user, IStatus[] statuses) throws ApplicationException;
    void outputFeed(FormatType formatType, ViewType viewType, IUser user, IDirectMessage[] directMessages) throws ApplicationException;
    
    /////
    
    IDirectMessage getDirectMessage(long directMessageId);
    IDirectMessage[] getDirectMessages(boolean sent, int page, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, long sinceId, int limit);
    IDirectMessage[] getDirectMessages(boolean sent, String since, int limit) throws ApplicationException;
    
    IDirectMessage createDirectMessage(String foreignKey, String text, String source) throws ApplicationException;
    IDirectMessage createDirectMessage(long userId, String text, String source) throws ApplicationException;
    IDirectMessage destroyDirectMessage(long directMessageId) throws ApplicationException;
    
    IDirectMessage[] prepareForView(IDirectMessage[] directMessages, boolean truncate);
    
    /////
    
    IFriendship getFriend(String foreignKey) throws ApplicationException;
    IFriendship[] getFriends(String foreignKey, int offset, int limit) throws ApplicationException;
    IFriendship[] getFriends(String foreignKey, boolean withFollower, int page, int limit) throws ApplicationException;
    IFriendship[] getFriends(long[] userIds) throws ApplicationException;
    IFriendship getFollower(String foreignKey) throws ApplicationException;
    IFriendship[] getFollowers(String foreignKey, boolean withFriend, int page, int limit) throws ApplicationException;
    IFriendship[] searchFriends(long userId, String keywords, SearchFriendsType type, int page, int limit);
    IFriendship[] getRequests(long activeId) throws ApplicationException;
    IFriendship[] getRequests(String foreignKey, int offset, int limit) throws ApplicationException;
    
    int countFriends(String foreignKey);
    int countFollows(String foreignKey);
    
    IFriendship createFriendship(String foreignKey) throws ApplicationException;
    IFriendship createFriendship(long userId) throws ApplicationException;
    IFriendship updateNotification(long userId, boolean notify) throws ApplicationException;
    IFriendship updateNotification(String foreignKey, boolean notify) throws ApplicationException;
    IFriendship acceptFriendship(long userId) throws ApplicationException;
    IFriendship acceptFriendship(String foreignKey) throws ApplicationException;
    IFriendship denyFriendship(String foreignKey) throws ApplicationException;
    IFriendship denyFriendship(long userId) throws ApplicationException;
    IFriendship destroyFriendship(String foreignKey) throws ApplicationException;
    IFriendship destroyFriendship(long userId) throws ApplicationException;
    
    IFriendship[] prepareForView(IFriendship[] friendships, int limit, boolean truncate);
    
    /////
    
    IFavorite[] getFavorites(long[] statusIds);
    IFavorite createFavorite(String foreignKey) throws ApplicationException;
    IFavorite createFavorite(long statusId) throws ApplicationException;
    int destroyFavorite(long statusId) throws ApplicationException;
    
    /////
    
    IDevice createDevice(String deviceType, String address);
    int activateDevice();
    int updateDevice(AvailabilityType availabilityType);
    int resetDevice();
    
    /////
    
    IDedicatedClient createClient(String key, String url, String version);
    int updateClient(IDedicatedClient client);
    IDedicatedClient getClient(String key);
    int removeClient(String key);
    
    /////
    
    IMobilePhone getMobilePhone() throws ApplicationException;
    boolean isMobilePhone() throws ApplicationException;
    
    /////
    
    IUser prepareForView(IUser user) throws ApplicationException;
    IUser[] prepareForView(IUser[] users, int limit);
    
    IDirectoryService getDirectoryService();
    IServerFileService getServerFileService();
}
