package jp.sourceforge.shovel.mobilephone.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.IEZweb;

public class EZwebImpl extends AbstractMobilePhoneImpl implements IEZweb {
    String serverName_;
    String comment_;
    boolean xhtmlCompliant_;
    int width_;
    int height_;
    int depth_;
    boolean color_;
    final static Map<String, String> images_;
    static {
        images_ = new HashMap<String, String>();
        images_.put("1","&#xF6FB;");
        images_.put("2","&#xF6FC;");
        images_.put("3","&#xF740;");
        images_.put("4","&#xF741;");
        images_.put("5","&#xF742;");
        images_.put("6","&#xF743;");
        images_.put("7","&#xF744;");
        images_.put("8","&#xF745;");
        images_.put("9","&#xF746;");
        images_.put("0","&#xF7C9;");
        images_.put("#","&#xF489;");
    }
    
    @Override
    public boolean isEZweb() {
        return true;
    }
    @Override
    public boolean isTUKa() {
        String tuka = getRawModel().substring(2, 1);
        if (isWAP2()) {
            return tuka.compareTo("U") == 0;
        }
        return tuka.compareTo("T") == 0;
    }
    public String getDeviceID() {
        return rawModel_;
    }
    public String getServer() {
        return serverName_;
    }
    public String getComment() {
        return comment_;
    }
    @Override
    public boolean isXHTMLCompliant() {
        return xhtmlCompliant_;
    }
    @Override
    public String getCarrierShortName() {
        return "E";
    }
    @Override
    public String getCarrierLongName() {
        return "EZweb";
    }
    public boolean isWIN() {
        return rawModel_.substring(2, 1).compareTo("3") == 0;
    }
    @Override
    public String getUID() {
        return getRequest().getHeader("X-UP-SUBNO");
    }
    public Map<String, String> getNumberImages() {
        return images_;
    }
    @Override
    public int getWidth() {
        return width_;
    }
    @Override
    public int getHeight() {
        return height_;
    }
    @Override
    public int getDepth() {
        return depth_;
    }
    @Override
    public boolean isColor() {
        return color_;
    }
    
    @Override
    void parse() throws ApplicationException {
        String userAgent = getUserAgent();
        Pattern pattern = Pattern.compile("^KDDI-(.*)");
        Matcher matcher = pattern.matcher(userAgent);
        if (matcher.find()) {
            //KDDI-TS21 UP.Browser/6.0.2.276 (GUI) MMP/1.1
            xhtmlCompliant_ = true;
            String[] tokens = matcher.group(1).split(" ", 4);
            rawModel_ = tokens[0];
            serverName_ = tokens[3];
            StringBuilder builder = new StringBuilder(tokens[2]);
            tokens = tokens[1].split("/");
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            name_ = tokens[0];
            builder.insert(0, " ");
            builder.insert(0, tokens[1]);
            version_ = builder.toString();
        } else {
            //UP.Browser/3.01-HI01 UP.Link/3.4.5.2
            String[] tokens = userAgent.split(" ", 3);
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            serverName_ = tokens[1];
            if (tokens.length == 3 && tokens[2] != null) {
                pattern = Pattern.compile("^\\((.*)\\)$");
                matcher = pattern.matcher(tokens[2]);
                if (matcher.find()) {
                    comment_ = matcher.group(1);
                }
            }
            tokens = tokens[0].split("/");
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            name_ = tokens[0];
            tokens = tokens[1].split("-");
            if (tokens == null || tokens.length < 2) {
                throw new ApplicationException("");
            }
            version_ = tokens[0];
            rawModel_ = tokens[1];
        }
        makeScreenInfo();
    }
    
    void makeScreenInfo() {
        String header = getRequest().getHeader("X-UP-DEVCAP-SCREENPIXELS");
        if (header != null && header.length() > 0) {
            String[] tokens = header.split(",");
            width_ = Integer.parseInt(tokens[0]);
            height_ = Integer.parseInt(tokens[1]);
        }
        header = getRequest().getHeader("X-UP-DEVCAP-SCREENDEPTH");
        if (header != null && header.length() > 0) {
            String[] tokens = header.split(",");
            depth_ = (int)Math.pow(2, Integer.valueOf(tokens[0]).doubleValue());
        }
        header = getRequest().getHeader("X-UP-DEVCAP-ISCOLOR");
        if (header != null && header.length() > 0) {
            color_ = header.compareTo("1") == 0;
        }
    }
}
