package jp.sourceforge.shovel.mobilephone.impl;

import static org.seasar.framework.container.ContainerConstants.REQUEST_NAME;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;

public abstract class AbstractMobilePhoneImpl implements IMobilePhone {
    String name_;
    String version_;
    String userAgent_;
    String model_;
    String rawModel_;
    final static Map<String, String> images_;
    static {
        images_ = new HashMap<String, String>();
        images_.put("1","[1]");
        images_.put("2","[2]");
        images_.put("3","[3]");
        images_.put("4","[4]");
        images_.put("5","[5]");
        images_.put("6","[6]");
        images_.put("7","[7]");
        images_.put("8","[8]");
        images_.put("9","[9]");
        images_.put("0","[0]");
        images_.put("#","[#]");
    }

    public String getName() {
        return name_;
    }
    public String getVersion() {
        return version_;
    }
    public String getUserAgent() {
        return userAgent_;
    }
    public String getModel() {
        if (model_ == null) {
            return getRawModel();
        } else {
            return model_;
        }
    }
    public String getRawModel() {
        return rawModel_;
    }
    public String getUID() {
        return null;
    }
    public int getWidth() {
        return 0;
    }
    public int getHeight() {
        return 0;
    }
    public int getDepth() {
        return 0;
    }
    public boolean isColor() {
        return false;
    }
    public int getWidthBytes() {
        return 0;
    }
    public int getHeightBytes() {
        return 0;
    }
    
    public AbstractMobilePhoneImpl() {
    }
    public boolean isDoCoMo() {
        return false;
    }
    public boolean isJPhone() {
        return false;
    }
    public boolean isVodafone() {
        return false;
    }
    public boolean isEZweb() {
        return false;
    }
    public boolean isAirHPhone() {
        return false;
    }
    public boolean isNotMobile() {
        return false;
    }
    public boolean isTUKa() {
        return false;
    }
    public boolean isWAP1() {
        return isEZweb() && !isWAP2();
    }
    public boolean isWAP2() {
        return isEZweb() && isXHTMLCompliant();
    }
    public String getCarrierShortName() {
        return null;
    }
    public String getCarrierLongName() {
        return null;
    }
    public boolean isSoftBank() {
        return false;
    }
    public boolean isWillcom() {
        return false;
    }
    public boolean isEmobile() {
        return false;
    }
    public boolean isXHTMLCompliant() {
        return false;
    }
    public Map<String, String> getNumberImages() {
        return images_;
    }
    
    public void parse(String userAgent) throws ApplicationException{
        if (userAgent == null || userAgent.length() <= 0) {
            throw new ApplicationException("");
        }
        userAgent_ = userAgent;
        parse();
    }
    abstract void parse() throws ApplicationException;
    
    S2Container container_;
    
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public S2Container getContainer() {
        return container_;
    }
    HttpServletRequest getRequest() {
        return (HttpServletRequest)getContainer().getComponent(REQUEST_NAME);
    }
}
