package jp.sourceforge.shovel.mobilephone;

import java.util.Map;

import jp.sourceforge.shovel.exception.ApplicationException;

public interface IMobilePhone {
    String getName();
    String getVersion();
    String getUserAgent();
    String getModel();
    String getRawModel();
    String getUID();
    String getCarrierShortName();
    String getCarrierLongName();
    Map<String, String> getNumberImages();
    int getWidth();
    int getHeight();
    int getDepth();
    boolean isColor();
    int getWidthBytes();
    int getHeightBytes();

    boolean isDoCoMo();
    boolean isJPhone();
    boolean isVodafone();
    boolean isEZweb();
    boolean isAirHPhone();
    boolean isNotMobile();
    boolean isTUKa();
    boolean isWAP1();
    boolean isWAP2();
    boolean isSoftBank();
    boolean isWillcom();
    boolean isEmobile();
    boolean isXHTMLCompliant();
    
    void parse(String userAgent) throws ApplicationException;
}
