package jp.sourceforge.shovel.logic.impl;

import static org.seasar.framework.container.ContainerConstants.*;

import java.util.regex.Pattern;

import javax.servlet.http.HttpServletRequest;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMobilePhoneLogic;
import jp.sourceforge.shovel.mobilephone.IDoCoMo;
import jp.sourceforge.shovel.mobilephone.IEZweb;
import jp.sourceforge.shovel.mobilephone.IMobilePhone;
import jp.sourceforge.shovel.mobilephone.ISoftBank;
import jp.sourceforge.shovel.mobilephone.IWillcom;

public class MobilePhoneLogicImpl implements IMobilePhoneLogic {
    public IMobilePhone createMobilePhone(String userAgent) throws ApplicationException {
        userAgent = getUserAgent(userAgent);
        if (userAgent == null || userAgent.length() <= 0) {
            return null;
        }
        
        Class<?> klass = null;
        if (isDoCoMo(userAgent)) {
            klass = IDoCoMo.class;
        } else if (isEZweb(userAgent)) {
            klass = IEZweb.class;
        } else if (isSoftBank(userAgent)) {
            klass = ISoftBank.class;
        } else if (isWillcom(userAgent)) {
            klass = IWillcom.class;
        } else {
            return null;
        }
        
        IMobilePhone mobilePhone = (IMobilePhone)getContainer().getComponent(klass);
        if (mobilePhone != null) {
            mobilePhone.parse(userAgent);
        }
        return mobilePhone;
    }
    public boolean isDoCoMo(String userAgent) {
        userAgent = getUserAgent(userAgent);
        if (userAgent == null || userAgent.length() <= 0) {
            return false;
        }
        return userAgent.startsWith("DoCoMo");
    }
    public boolean isEZweb(String userAgent) {
        userAgent = getUserAgent(userAgent);
        if (userAgent == null || userAgent.length() <= 0) {
            return false;
        }
        if (userAgent.startsWith("KDDI-")) {
            return true;
        }
        return userAgent.startsWith("UP.Browser");
    }
    public boolean isSoftBank(String userAgent) {
        userAgent = getUserAgent(userAgent);
        if (userAgent == null || userAgent.length() <= 0) {
            return false;
        }
        if (userAgent.startsWith("SoftBank")) {
            return true;
        } else if (userAgent.startsWith("Semulator")) {
            return true;
        } else if (userAgent.startsWith("Vodafone")) {
            return true;
        } else if (userAgent.startsWith("Vemulator")) {
            return true;
        } else if (userAgent.startsWith("MOT-")) {
            return true;
        } else if (userAgent.startsWith("MOTEMULATOR")) {
            return true;
        } else if (userAgent.startsWith("J-PHONE")) {
            return true;
        }
        return userAgent.startsWith("J-EMULATOR");
    }
    public boolean isWillcom(String userAgent) {
        if (userAgent == null || userAgent.length() <= 0) {
            return false;
        }
        return userAgent.matches("^Mozilla/3\\.0\\((?:DDIPOCKET|WILLCOM);.+");
    }
    
    String getUserAgent(String userAgent) {
        if (userAgent == null || userAgent.length() <= 0) {
            userAgent = getRequest().getHeader("USER-AGENT");
        }
        return userAgent;
    }
    HttpServletRequest getRequest() {
        return (HttpServletRequest)getContainer().getComponent(REQUEST_NAME);
    }
    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }
}
