package jp.sourceforge.shovel.form.impl;

import static jp.sourceforge.shovel.FormatType.*;
import static jp.sourceforge.shovel.MethodType.*;

import org.seasar.struts.annotation.tiger.StrutsActionForm;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.form.IUsersForm;

@StrutsActionForm(name = "usersForm")
public class UsersFormImpl implements IUsersForm {
    FormatType formatType_;
    String keyword_;
    MethodType methodType_;
    boolean partial_;
    int page_;
    int count_;
    
    public String getFormat() {
        return getFormatType().getId();
    }
    public void setFormat(String format) {
        setFormatType(FormatType.find(format));
    }
    public FormatType getFormatType() {
        return formatType_ == null ? HTML : formatType_;
    }
    public void setFormatType(FormatType formatType) {
        formatType_ = formatType;
    }
    public String getKeyword() {
        return keyword_ == null ? "" : keyword_;
    }
    public void setKeyword(String keyword) {
        keyword_ = keyword;
    }
    public String getMethod() {
        return getMethodType().getId();
    }
    public void setMethod(String method) {
        setMethodType(MethodType.find(method));
    }
    public MethodType getMethodType() {
        return methodType_ == null ? RELOAD : methodType_;
    }
    public void setMethodType(MethodType methodType) {
        methodType_ = methodType;
    }
    public boolean isPartial() {
        return partial_;
    }
    public void setPartial(boolean partial) {
        partial_ = partial;
    }
    public int getPage() {
        return page_;
    }
    public void setPage(int page) {
        page_ = page;
    }
    public int getCount() {
        return count_;
    }
    public void setCount(int count) {
        count_ = count;
    }
}
