package jp.sourceforge.shovel.form.impl;

import static jp.sourceforge.shovel.FormatType.*;
import static jp.sourceforge.shovel.ViewType.*;

import org.seasar.struts.annotation.tiger.StrutsActionForm;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.form.IStatusForm;

@StrutsActionForm(name = "statusForm")
public class StatusFormImpl implements IStatusForm {
    int count_;
    FormatType formatType_;
    int page_;
    boolean partial_;
    long statusId_;
    String source_;
    String status_;
    ViewType viewType_;
    
    public int getCount() {
        return count_;
    }
    public void setCount(int count) {
        count_ = count;
    }
    public String getFormat() {
        return getFormatType().getId();
    }
    public void setFormat(String format) {
        setFormatType(FormatType.find(format));
    }
    public FormatType getFormatType() {
        return formatType_ == null ? HTML : formatType_;
    }
    public void setFormatType(FormatType formatType) {
        formatType_ = formatType;
    }
    public String getStatus() {
        return status_ == null ? "" : status_;
    }
    public void setStatus(String status) {
        status_ = status;
    }
    public String getSource() {
        return source_ == null ? "" : source_;
    }
    public void setSource(String source) {
        source_ = source;
    }
    public int getPage() {
        return page_;
    }
    public void setPage(int page) {
        page_ = page;
    }
    public boolean isPartial() {
        return partial_;
    }
    public void setPartial(boolean partial) {
        partial_ = partial;
    }
    public long getStatusId() {
        return statusId_;
    }
    public void setStatusId(long statusId) {
        statusId_ = statusId;
    }
    public String getView() {
        return getViewType().getId();
    }
    public void setView(String view) {
        setViewType(ViewType.find(view));
    }
    public ViewType getViewType() {
        return viewType_ == null ? RECENT : viewType_;
    }
    public void setViewType(ViewType viewType) {
        viewType_ = viewType;
    }
}
