package jp.sourceforge.shovel.form.impl;

import static jp.sourceforge.shovel.FormatType.*;
import static jp.sourceforge.shovel.MethodType.*;
import static jp.sourceforge.shovel.SearchFriendsType.*;

import org.seasar.struts.annotation.tiger.StrutsActionForm;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.SearchFriendsType;
import jp.sourceforge.shovel.form.IFriendsForm;

@StrutsActionForm(name = "friendshipForm")
public class FriendsFormImpl implements IFriendsForm {
    int count_;
    String foreignKey_;
    FormatType formatType_;
    String friends_;
    String keyword_;
    MethodType methodType_;
    int page_;
    boolean partial_;
    SearchFriendsType searchFriendsType_;
    long userId_;
    
    public int getCount() {
        return count_;
    }
    public void setCount(int count) {
        count_ = count;
    }
    public String getForeignKey() {
        return foreignKey_ == null ? "" : foreignKey_;
    }
    public void setForeignKey(String foreignKey) {
        foreignKey_ = foreignKey;
    }
    public String getFormat() {
        return getFormatType().getId();
    }
    public void setFormat(String format) {
        setFormatType(FormatType.find(format));
    }
    public FormatType getFormatType() {
        return formatType_ == null ? HTML : formatType_;
    }
    public void setFormatType(FormatType formatType) {
        formatType_ = formatType;
    }
    public String getFriends() {
        return friends_;
    }
    public boolean isFollowers() {
        return friends_ == null || friends_.compareTo("followers") == 0;
    }
    public void setFriends(String friends) {
        friends_ = friends;
    }
    public String getKeyword() {
        return keyword_ == null ? "" : keyword_;
    }
    public void setKeyword(String keyword) {
        keyword_ = keyword;
    }
    public String getMethod() {
        return getMethodType().getId();
    }
    public void setMethod(String method) {
        setMethodType(MethodType.find(method));
    }
    public MethodType getMethodType() {
        return methodType_ == null ? RELOAD : methodType_;
    }
    public void setMethodType(MethodType methodType) {
        methodType_ = methodType;
    }
    public int getPage() {
        return page_;
    }
    public void setPage(int page) {
        page_ = page;
    }
    public boolean isPartial() {
        return partial_;
    }
    public void setPartial(boolean partial) {
        partial_ = partial;
    }
    public SearchFriendsType getSearchFriendsType() {
        return searchFriendsType_ == null ? FOLLOWING : searchFriendsType_;
    }
    public void setSearchFriendsType(SearchFriendsType searchFriendsType) {
        searchFriendsType_ = searchFriendsType;
    }
    public int getType() {
        return getSearchFriendsType().getId();
    }
    public void setType(int type) {
        setSearchFriendsType(SearchFriendsType.find(type));
    }
    public long getUserId() {
        return userId_;
    }
    public void setUserId(long userId) {
        userId_ = userId;
    }
}
