package jp.sourceforge.shovel.exception;

/**
 * エラーページを出力する例外
 */
public class ApplicationRuntimeException extends RuntimeException {
    private static final long serialVersionUID = -1L;
    // キーは5桁の数字
    private static final int ERROR_KEY_LENGTH = 5;
    private String[] causeArgs = null;
    private String[] counterMeasureArgs = null;
    private String[] developerInfoArgs = null;
    private String[] diagnosisArgs = null;
    private String errorCode;
    private String outputErrorCode;
    private String bundle;
    private String key;

    public ApplicationRuntimeException( String errorCode ) {
        this(errorCode, null);
    }
    public ApplicationRuntimeException(String errorCode, String[] diagnosisArgs) {
        this(errorCode, diagnosisArgs, null);
    }
    public ApplicationRuntimeException(String errorCode, String[] diagnosisArgs, String[] causeArgs) {
        this(errorCode, diagnosisArgs, causeArgs, null);
    }
    public ApplicationRuntimeException(String errorCode, String[] diagnosisArgs, String[] causeArgs, String[] counterMeasureArgs) {
        this( errorCode, diagnosisArgs, causeArgs, counterMeasureArgs, null );
    }
    public ApplicationRuntimeException(String errorCode, String[] diagnosisArgs, String[] causeArgs, String[] counterMeasureArgs, String[] developerInfoArgs) {
        super();
        setErrorCode(errorCode);
        setDiagnosisArgs(diagnosisArgs);
        setCauseArgs(causeArgs);
        setCounterMeasureArgs(counterMeasureArgs);
        setDeveloperInfoArgs(developerInfoArgs);
        Throwable t = fillInStackTrace();
        setStackTrace(t.getStackTrace());
    }
    private void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        int end = errorCode.length();
        int begin = end - ERROR_KEY_LENGTH;
        bundle = errorCode.substring(0, begin);
        key = errorCode.substring(begin, end);
    }
    public String getErrorCode() {
        return errorCode;
    }
    public void setOutputErrorCode(String errorCode) {
        this.outputErrorCode = errorCode;
    }
    public String getOutputErrorCode()
    {
        return this.outputErrorCode;
    }
    public String getBundle()
    {
        return bundle;
    }

    public String getKey()
    {
        return key;
    }

    public void setCauseArgs( String[] causeArgs )
    {
        if( causeArgs != null )
        {
            this.causeArgs = causeArgs;
        }
    }
    public void setCauseArgs( String arg1 )
    {
        setCauseArgs( arg1, null );
    }
    public void setCauseArgs( String arg1, String arg2 )
    {
        setCauseArgs( arg1, arg2, null );
    }
    public void setCauseArgs( String arg1, String arg2, String arg3 )
    {
        setCauseArgs( arg1, arg2, arg3, null );
    }
    public void setCauseArgs( String arg1, String arg2, String arg3, String arg4 )
    {
        setCauseArgs( arg1, arg2, arg3, arg4, null );
    }
    public void setCauseArgs( String arg1, String arg2, String arg3, String arg4, String arg5 ) {
        setCauseArgs( new String[]{ arg1, arg2, arg3, arg4, arg5 } );
    }
    public String[] getCauseArgs() {
        return causeArgs;
    }

    public void setCounterMeasureArgs( String[] counterMeasureArgs ) {
        if( counterMeasureArgs != null ) {
            this.counterMeasureArgs = counterMeasureArgs;
        }
    }
    public void setCounterMeasureArgs( String arg1 ) {
        setCounterMeasureArgs( arg1, null );
    }
    public void setCounterMeasureArgs( String arg1, String arg2 ) {
        setCounterMeasureArgs( arg1, arg2, null );
    }
    public void setCounterMeasureArgs( String arg1, String arg2, String arg3 ) {
        setCounterMeasureArgs( arg1, arg2, arg3, null );
    }
    public void setCounterMeasureArgs( String arg1, String arg2, String arg3, String arg4 ) {
        setCounterMeasureArgs( arg1, arg2, arg3, arg4, null );
    }
    public void setCounterMeasureArgs( String arg1, String arg2, String arg3, String arg4, String arg5 ) {
        setCounterMeasureArgs( new String[]{ arg1, arg2, arg3, arg4, arg5 } );
    }
    public String[] getCounterMeasureArgs() {
        return counterMeasureArgs;
    }

    public void setDeveloperInfoArgs( String[] developerInfoArgs ) {
        if( developerInfoArgs != null ) {
            this.developerInfoArgs = developerInfoArgs;
        }
    }
    public void setDeveloperInfoArgs( String arg1 ) {
        setDeveloperInfoArgs( arg1, null );
    }
    public void setDeveloperInfoArgs( String arg1, String arg2 ) {
        setDeveloperInfoArgs( arg1, arg2, null );
    }
    public void setDeveloperInfoArgs( String arg1, String arg2, String arg3 ) {
        setDeveloperInfoArgs( arg1, arg2, arg3, null );
    }
    public void setDeveloperInfoArgs( String arg1, String arg2, String arg3, String arg4 ) {
        setDeveloperInfoArgs( arg1, arg2, arg3, arg4, null );
    }
    public void setDeveloperInfoArgs( String arg1, String arg2, String arg3, String arg4, String arg5 ) {
        setDeveloperInfoArgs( new String[]{ arg1, arg2, arg3, arg4, arg5 } );
    }
    public String[] getDeveloperInfoArgs() {
        return developerInfoArgs;
    }

    public void setDiagnosisArgs( String[] diagnosisArgs ) {
        if( diagnosisArgs != null ) {
            this.diagnosisArgs = diagnosisArgs;
        }
    }
    public void setDiagnosisArgs( String arg1 ) {
        setDiagnosisArgs( arg1, null );
    }
    public void setDiagnosisArgs( String arg1, String arg2 ) {
        setDiagnosisArgs( arg1, arg2, null );
    }
    public void setDiagnosisArgs( String arg1, String arg2, String arg3 ) {
        setDiagnosisArgs( arg1, arg2, arg3, null );
    }
    public void setDiagnosisArgs( String arg1, String arg2, String arg3, String arg4 ) {
        setDiagnosisArgs( arg1, arg2, arg3, arg4, null );
    }
    public void setDiagnosisArgs( String arg1, String arg2, String arg3, String arg4, String arg5 ) {
        setDiagnosisArgs( new String[]{ arg1, arg2, arg3, arg4, arg5 } );
    }
    public String[] getDiagnosisArgs() {
        return diagnosisArgs;
    }
}
