package jp.sourceforge.shovel.device.impl;

import static jp.sourceforge.shovel.AvailabilityType.*;

import jp.sourceforge.shovel.device.IMsnpWrapper;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.impl.MsnMessengerFactory;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;

public class MsnpWrapperImpl extends AbstractDelayExecutorImpl implements IMsnpWrapper {
    public String getEmail() {
        return properties_.getProperty("userId");
    }
    public String getPassword() {
        return properties_.getProperty("password");
    }
    public String getExecutorId() {
        return "msnp";
    }
    public String getAddress() {
        return getEmail();
    }
    
    /////
    
    MsnMessenger messenger_;
    boolean login_;
    
    public void login() throws ApplicationException {
        /*
        Email email = Email.parseStr(getEmail());
        if (email == null) {
            throw new ApplicationException("");
        }
        messenger_ = new MyMessenger(email, getPassword());
        */
        
        //1863番ポートが塞がってるとうまく繋がらん。。
        messenger_ = MsnMessengerFactory.createMsnMessenger(getEmail(), getPassword());

        messenger_.setLogIncoming(true);
        messenger_.setLogOutgoing(true);
        messenger_.addContactListListener(this);
        messenger_.addMessengerListener(this);
        messenger_.addMessageListener(this);
        
        messenger_.login();
    }
    public void logout() {
        messenger_.logout();
    }
    public void sendMessage(IUser receiver, String body) {
        IDevice device = receiver.getDevice();
        if (getExecutorId().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == ON) {
            String address = receiver.getAddress();
            if (address == null || address.length() <= 0) {
                return;
            }
            Email email = Email.parseStr(address);
            messenger_.sendText(email, body);
        }
    }
    public boolean isConnected() {
        return messenger_ != null && login_;
    }
    public void contactAddedMe(MsnMessenger messenger, MsnContact contact) {
        //TODO 友だち名簿に登録する必要なし？
        //messenger.addFriend(contact.getEmail(), contact.getFriendlyName());
    }
    public void contactListSyncCompleted(MsnMessenger messenger) {
        
    }
    public void contactListInitCompleted(MsnMessenger messenger) {
        
    }
    public void contactStatusChanged(MsnMessenger messenger, MsnContact contact) {
        
    }
    public void ownerStatusChanged(MsnMessenger messenger) {
        
    }
    public void contactRemovedMe(MsnMessenger messenger, MsnContact contact) {
        
    }
    public void contactAddCompleted(MsnMessenger messenger, MsnContact contact) {
        
    }
    public void contactRemoveCompleted(MsnMessenger messenger, MsnContact contact) {
        
    }
    public void groupAddCompleted(MsnMessenger messenger, MsnGroup group) {
        
    }
    public void groupRemoveCompleted(MsnMessenger messenger, MsnGroup group) {
        
    }
    public void loginCompleted(MsnMessenger messenger) {
        login_ = true;
    }
    public void logout(MsnMessenger messenger) {
        login_ = false;
        messenger_ = null;
    }
    public void exceptionCaught(MsnMessenger messenger, Throwable throwable) {
        
    }
    public void instantMessageReceived(MsnSwitchboard switchboard,
            MsnInstantMessage message, MsnContact contact) {
        try {
            String address = contact.getEmail().getEmailAddress();
            String body = message.getContent();
            this.receiveMessage(address, body);
        } catch (ApplicationException e) {
            //TODO 受信に失敗
        }
    }
    public void controlMessageReceived(MsnSwitchboard switchboard,
            MsnControlMessage message, MsnContact contact) {
    }
    public void systemMessageReceived(MsnMessenger messenger,
            MsnSystemMessage message) {
    }
    public void datacastMessageReceived(MsnSwitchboard switchboard,
            MsnDatacastMessage message, MsnContact contact) {
    }
    public void unknownMessageReceived(MsnSwitchboard switchboard,
            MsnUnknownMessage message, MsnContact contact) {
    }
    public void p2pMessageReceived(MsnSwitchboard switchboard,
            MsnP2PMessage message,
            MsnContact contact) {
    }
}
