package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.impl.StatusImpl;

@S2Dao(bean = StatusImpl.class)
public interface IStatusDao {
    int insert(IStatus status);
    
    @Arguments({"statusId","removedTime"})
    int updateRemovedTime(long statusId, long removedTime);
    @Arguments("referenceId")
    int updateReference(long referenceId);
    @Arguments("statusId")
    int updateIncrementGivenFavorites(long statusId);
    @Arguments("statusId")
    int updateDecrementGivenFavorites(long statusId);
    
    int delete();
    
    @Arguments("statusId")
    IStatus find(long statusId);
    @Arguments("userId")
    IStatus findRecent(long userId);
    //senderId, statusIdのみ返し他は返さないので注意
    @Arguments({"userIds", "offset", "limit"})
    IStatus[] findAllRecent(long[] userIds, int offset, int limit);
    @Arguments({"statusIds", "sortType", "sortOrderType", "offset", "limit"})
    IStatus[] findAll(long[] statusIds, SortType sortType, SortOrderType sortOrderType, int offset, int limit);
    @Arguments({"sinceTime", "useRemoved", "limit"})
    IStatus[] findAllBySinceTime(long sinceTime, boolean useRemoved, int limit);
    @Arguments({"sinceId", "limit"})
    IStatus[] findAllBySinceId(long sinceId, int limit);
    @Arguments({"userId", "offset", "limit"})
    IStatus[] findAllFavorite(long userId, int offset, int limit);
    @Arguments({"userId", "offset", "limit"})
    IStatus[] findAllReply(long userId, int offset, int limit);
    @Arguments({"userId", "offset", "limit"})
    IStatus[] findAllSingle(long userId, int offset, int limit);
    @Arguments({"userId", "sentTime", "limit"})
    IStatus[] findAllSingleSinceTime(long userId, long sentTime, int limit);
    @Arguments({"userId", "repliesType", "offset", "limit"})
    IStatus[] findAllWithFriends(long userId, RepliesType repliesType, int offset, int limit);
    @Arguments({"userId", "repliesType", "sentTime", "limit"})
    IStatus[] findAllWithFriendsSinceTime(long userId, RepliesType repliesType, long sentTime, int limit);
}
