package jp.sourceforge.shovel.dao;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.impl.DeviceImpl;

@S2Dao(bean = DeviceImpl.class)
public interface IDeviceDao {
    void insert(IDevice device);
    
    @Arguments("device")
    int update(IDevice device);
    @Arguments("device")
    int updateByUser(IDevice device);
    
    @Arguments("deviceId")
    int delete(long deviceId);
    @Arguments("userId")
    int deleteByUser(long userId);
}
