package jp.sourceforge.shovel.dao;

import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.impl.DedicatedClientImpl;

import org.seasar.dao.annotation.tiger.Arguments;
import org.seasar.dao.annotation.tiger.S2Dao;

@S2Dao(bean = DedicatedClientImpl.class)
public interface IDedicatedClientDao {
    void insert(IDedicatedClient client);
    
    @Arguments("client")
    int update(IDedicatedClient client);
    
    @Arguments("text")
    IDedicatedClient findByKey(String key);
    @Arguments({"texts", "offset", "limit"})
    IDedicatedClient[] findAllByText(String[] texts, int offset, int limit);
    
    @Arguments("text")
    int deleteByText(String text);
}
