package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.action.ISettingsAction;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.ISettingsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class SettingsActionImpl implements ISettingsAction {
    ISettingsForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        IDirectoryService directoryService = getShovelService().getDirectoryService();
        IUser user = directoryService.getLoginUser();
        user.setDisplayName(actionForm_.getDisplayName());
        user.setForeignKey(actionForm_.getForeignKey());
        user.setEmail(actionForm_.getEmail());
        user.setTimeZone(actionForm_.getTimeZone());
        user.setDescription(actionForm_.getDescription());
        user.setLocation(actionForm_.getLocation());
        user.setProtect(actionForm_.isProtect());
        user.setViewLines(actionForm_.getViewLines());
        directoryService.updateUser(user);
        return null;
    }
    public void setSettingsForm(ISettingsForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
}
