package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SessionConst.*;
import static jp.sourceforge.shovel.MethodType.*;
import static jp.sourceforge.shovel.ViewType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.seasar.framework.container.S2Container;

import jp.sourceforge.shovel.action.IFriendRequestsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class FriendRequestsActionImpl implements IFriendRequestsAction {
    IFriendsForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    
    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        int page = actionForm_.getPage();
        
        IListRefine listRefine = (IListRefine)getSession().getAttribute(S_LIST_REFINE);
        if (listRefine == null || !listRefine.getViewType().isFriendRequests()) {
            listRefine = (IListRefine)container_.getComponent(IListRefine.class);
            getSession().setAttribute(S_LIST_REFINE, listRefine);
        } else if (actionForm_.getMethodType() == PAGE) {
            listRefine.setPage(actionForm_.getPage());
        }
        listRefine.setViewType(FRIEND_REQUESTS);
        
        page = listRefine.getPage();
        
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = actionForm_.getForeignKey();
        long userId = actionForm_.getUserId();
        IUser user;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else if (foreignKey.matches("^[0-9]+$")) {
            user = directoryService.getUser(userId);
        } else {
            user = directoryService.getUser(foreignKey);
        }
        
        IFriendship[] tmp = shovelService.getRequests(foreignKey, page, 0);
        IFriendship[] friends = shovelService.prepareForView(tmp, 0, true);
        request_.setAttribute("friendships", friends);
        shovelService.prepareForView(user);
        request_.setAttribute("user", user);
        
        if (friends != null && friends.length > 0) {
            request_.setAttribute("nextPage", tmp.length > friends.length);
        }
        
        return actionForm_.isPartial() ? PARTIAL : FULL;
    }
    public void setFriendshipForm(IFriendsForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
    public void setContainer(S2Container container) {
        container_ = container;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
}
