package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.IDestroyFriendshipAction;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyFriendshipActionImpl implements IDestroyFriendshipAction {
    IFriendsForm actionForm_;
    HttpServletRequest request_;
    
    public String perform() throws Exception {
        FormatType formatType = actionForm_.getFormatType();
        long userId = actionForm_.getUserId();
        String foreignKey = actionForm_.getForeignKey();
        
        IShovelService shovelService = getShovelService();
        IFriendship friend;
        if (foreignKey == null || foreignKey.length() <= 0) {
            IDirectoryService directoryService = shovelService.getDirectoryService();
            IUser user = directoryService.getLoginUser();
            userId = user.getUserId();
            friend = shovelService.destroyFriendship(userId);
        } else if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            friend = shovelService.destroyFriendship(userId);
        } else {
            userId = 0;
            friend = shovelService.destroyFriendship(foreignKey);
        }
        
        String forward = null;
        switch (formatType) {
        case HTML:
            if (shovelService.isMobilePhone()) {
                request_.setAttribute("post", "leaveFriend");
                forward = MOBILE;
            }
            break;
        case XML:
        case JSON:
            shovelService.prepareForView(new IFriendship[] {friend}, 1, false);
            request_.setAttribute("friendship", friend);
            request_.setAttribute("friends", true);
            
            IStatus status = null;
            if (userId > 0) {
                status = shovelService.getRecent(userId);
            } else {
                status = shovelService.getRecent(foreignKey);
            }
            
            if (status != null) {
                shovelService.prepareForView(status);
                Map<String, IStatus> statusMap = new HashMap<String, IStatus>();
                statusMap.put(String.valueOf(friend.getPassiveId()), status);
                request_.setAttribute("statuses", statusMap);
            }
            
            forward = formatType.getId();
            break;
        default:
            throw new ApplicationException("");
        }
        
        return forward;
    }
    
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    public void setFriendshipForm(IFriendsForm actionForm) {
        actionForm_ = actionForm;
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
