package jp.sourceforge.shovel.action.impl;

import static jp.sourceforge.shovel.SessionConst.*;
import static jp.sourceforge.shovel.SortType.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.action.ICreateAccountAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.ICreateAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IServerFileService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.ServerFileUtil;

public class CreateAccountActionImpl implements ICreateAccountAction {
    ICreateAccountForm actionForm_;
    HttpServletRequest request_;
    
    @Perform(CSRF=true, administrator=true)
    public String perform() throws Exception {
        IShovelService shovelService = getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IServerFileService serverFileService = shovelService.getServerFileService();
        String displayName = actionForm_.getDisplayName();
        String foreignKey = actionForm_.getForeignKey();
        String email = actionForm_.getEmail();
        IServerFile serverFile = ServerFileUtil.toServerFile(actionForm_.getFile(), null, null);
        String location = actionForm_.getLocation();
        String timeZoneId = actionForm_.getTimeZoneId();
        String description = actionForm_.getDescription();
        String password = actionForm_.getPassword();
        boolean protect = actionForm_.isProtect();
        serverFileService.createServerFile(serverFile, true, false);
        directoryService.createUser(displayName, foreignKey, password, email, serverFile,
                location, timeZoneId, description, protect, true);
        IListRefine listRefine = (IListRefine)getSession().getAttribute(S_LIST_REFINE);
        SortOrderType sortOrderType = listRefine.getSortOrderType();
        //0頁目に戻す
        IUser[] users = directoryService.getUsers(USER_ID, sortOrderType, 0);
        if (users != null && users.length > 0) {
            IUser[] tmp = shovelService.prepareForView(users, 0);
            request_.setAttribute("nextPage", users.length > tmp.length);
            users = tmp;
        }
        request_.setAttribute("users", users);
        
        request_.setAttribute("callback", "window.parent.shovel.controller.onChangeConfig($('#content').html());");
        request_.setAttribute("template", "system/accounts.ftl");
        
        return SUCCESS;
    }
    public void setCreateAccountForm(ICreateAccountForm actionForm) {
        actionForm_ = actionForm;
    }
    public void setRequest(HttpServletRequest request) {
        request_ = request;
    }
    HttpSession getSession() {
        return request_.getSession(true);
    }
    public IShovelService getShovelService() {
        return (IShovelService)request_.getAttribute("shovelService");
    }
}
