package jp.sourceforge.shovel;

public enum ViewType {
    //web
    ARCHIVE             ("archive"),
    FAVORITES           ("favorites"),
    PREVIOUS            ("previous"),
    PUBLIC_TIMELINE     ("publicTimeline"),
    RECENT              ("recent"),
    REPLIES             ("replies"),
    WITH_FRIENDS        ("withFriends"),
    INBOX               ("inbox"),
    SENT                ("sent"),
    SEARCH_USERS        ("searchUsers"),
    //api
    FRIENDS_TIMELINE    ("friendsTimeline"),
    USER_TIMELINE       ("userTimeline"),
    //follow
    FRIENDS             ("friends"),
    FOLLOWERS           ("followers"),
    FRIEND_REQUESTS     ("friendRequests"),
    //system accounts
    ACCOUNTS            ("accounts");
    
    String id_;
    
    ViewType(String id) {
        id_ = id;
    }
    public String getId() {
        return id_;
    }
    public static ViewType find(String id) {
        id = id.toLowerCase();
        for(ViewType type :ViewType.values()) {
            if(id.compareTo(type.getId()) == 0) {
                return type;
            }
        }
        return RECENT;
    }
    public boolean isArchive() {
        return this == ARCHIVE;
    }
    public boolean isFavorites() {
        return this == FAVORITES;
    }
    public boolean isPrevious() {
        return this == PREVIOUS;
    }
    public boolean isPublicTimeline() {
        return this == PUBLIC_TIMELINE;
    }
    public boolean isRecent() {
        return this == RECENT;
    }
    public boolean isReplies() {
        return this == REPLIES;
    }
    public boolean isWithFriends() {
        return this == WITH_FRIENDS;
    }
    public boolean isInbox() {
        return this == INBOX;
    }
    public boolean isSent() {
        return this == SENT;
    }
    public boolean isFriendsTimeline() {
        return this == FRIENDS_TIMELINE;
    }
    public boolean isUserTimeline() {
        return this == USER_TIMELINE;
    }
    public boolean isFriends() {
        return this == FRIENDS;
    }
    public boolean isFollowers() {
        return this == FOLLOWERS;
    }
    public boolean isFriendRequests() {
        return this == FRIEND_REQUESTS;
    }
    public boolean isAccounts() {
        return this == ACCOUNTS;
    }
    public boolean isSearchUsers() {
        return this == SEARCH_USERS;
    }
}
