package jp.sourceforge.shovel;

public enum ThumbnailType {
    SHOVEL          ("shovel"),
    IMAGE_MAGICK    ("image_magick");
    
    String key_;
    
    ThumbnailType(String key) {
        key_ = key;
    }
    public String getKey() {
        return key_;
    }
    public static ThumbnailType find(String key) {
        for (ThumbnailType type : ThumbnailType.values()) {
            if (key.compareTo(type.getKey()) == 0) {
                return type;
            }
        }
        return SHOVEL;
    }
    public boolean isShovel() {
        return this == SHOVEL;
    }
    public boolean isImageMagick() {
        return this == IMAGE_MAGICK;
    }
}
