package jp.sourceforge.shovel;

public enum SystemConfigType {
    ACCOUNTS        ("accounts", "accounts.ftl"),
    IMPORT_ACCOUNTS ("accounts/import", "/system/accounts/import.ftl"),
    CREATE_ACCOUNT  ("accounts/create", "/system/accounts/create.ftl"),
    UPDATE_ACCOUNT  ("accounts/update", "/system/accounts/update.ftl");
    
    String forward_;
    String template_;
    
    SystemConfigType(String forward, String template) {
        forward_ = forward;
        template_ = template;
    }
    public String getForward() {
        return forward_;
    }
    public String getTemplate() {
        return template_;
    }
    public static SystemConfigType find(String forward) {
        for(SystemConfigType type :SystemConfigType.values()) {
            if(forward.compareTo(type.getForward()) == 0) {
                return type;
            }
        }
        return null;
    }
}
