package jp.sourceforge.shovel;

public enum SortOrderType {
    DESC    ("DESC"),
    ASC     ("ASC");
    
    String sortOrder_;
    
    SortOrderType(String sortOrder) {
        sortOrder_ = sortOrder;
    }
    public String getSortOrder() {
        return sortOrder_;
    }
    public static SortOrderType find(String sortOrder) {
        for(SortOrderType type :SortOrderType.values()) {
            if(sortOrder.compareToIgnoreCase(type.getSortOrder()) == 0) {
                return type;
            }
        }
        return DESC;
    }
    public boolean isDesc() {
        return this == DESC;
    }
    public boolean isAsc() {
        return this == ASC;
    }
}
