package jp.sourceforge.shovel;

public enum GrowlType {
    REGISTRATION        ((byte)0),
    NOTIFICATION        ((byte)1),
    REGISTRATION_SHA256 ((byte)2),
    NOTIFICATION_SHA256 ((byte)3),
    REGISTRATION_NOAUTH ((byte)4),
    NOTIFICATION_NOAUTH ((byte)5);
    
    byte id_;
    
    public byte getId() {
        return id_;
    }
    GrowlType(byte id) {
        id_ = id;
    }
    public GrowlType find(byte id) {
        for (GrowlType type : GrowlType.values()) {
            if(id == type.getId()) {
                return type;
            }
        }
        return null;
    }
    public boolean isRegistration() {
        return this == REGISTRATION;
    }
    public boolean isNotification() {
        return this == NOTIFICATION;
    }
}
