package jp.sourceforge.shovel;

public enum FormatType {
    HTML    ("html", null, ""),
    XML     ("xml", "text/xml", ""),
    JSON    ("json", "text/javascript+json", ""),
    RSS     ("rss", "application/rss+xml", "rss_2.0"),
    ATOM    ("atom", "application/atom+xml", "atom_1.0");
    
    String id_;
    String mimeType_;
    String feedType_;
    
    FormatType(String id, String mimeType, String feedType) {
        id_ = id;
        mimeType_ = mimeType;
        feedType_ = feedType;
    }
    public String getId() {
        return id_;
    }
    public String getMimeType() {
        return mimeType_;
    }
    public String getFeedType() {
        return feedType_;
    }
    public static FormatType find(String id) {
        if (id != null) {
            for (FormatType type :FormatType.values()) {
                if(id.compareTo(type.getId()) == 0) {
                    return type;
                }
            }
        }
        return HTML;
    }
    public boolean isHtml() {
        return this == HTML;
    }
    public boolean isXml() {
        return this == XML;
    }
    public boolean isJson() {
        return this == JSON;
    }
    public boolean isRss() {
        return this == RSS;
    }
    public boolean isAtom() {
        return this == ATOM;
    }
}
